/*
 * <<< r3081.cc >>>
 *
 * --- R3081 class 'r3081'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "r3081.h"

using namespace std;

r3081::r3081(void)
	: inst_cache(default_instruction_cache_size,
				 default_instruction_cache_line_size),
	  data_cache(default_data_cache_size,
				 default_data_cache_line_size)
{
	inherited::connect_coprocessor(fpa);
	inherited::connect_instruction_cache(inst_cache);
	inherited::connect_data_cache(data_cache);
}

r3081::r3081(const r3081& a)
	: inherited(a),
	  fpa(a.fpa),
	  inst_cache(a.inst_cache.cache_size(), a.inst_cache.line_size()),
	  data_cache(a.data_cache.cache_size(), a.data_cache.line_size())
{
	inherited::connect_coprocessor(fpa);
	inherited::connect_instruction_cache(inst_cache);
	inherited::connect_data_cache(data_cache);
}

r3081::~r3081()
{}

void r3081::enable_coprocessor(void)
{
	inherited::connect_coprocessor(fpa);
}

void r3081::enable_instruction_cache(void)
{
	inherited::connect_instruction_cache(inst_cache);
}

void r3081::enable_data_cache(void)
{
	inherited::connect_data_cache(data_cache);
}

void r3081::disable_coprocessor(void)
{
	inherited::disconnect_coprocessor();
}

void r3081::disable_instruction_cache(void)
{
	inherited::disconnect_instruction_cache();
}

void r3081::disable_data_cache(void)
{
	inherited::disconnect_data_cache();
}

bool r3081::output(ostream& os, const string& s) const
{
	if (s == "fpa" || s == "cp1") {
		os << fpa;
		return true;
	} else if (s == "instruction_cache" || s == "icache") {
		os << inst_cache;
		return true;
	} else if (s == "data_cache" || s == "dcache") {
		os << data_cache;
		return true;
	}
	return inherited::output(os, s);
}
