/*
 * <<< r3010_mem.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "r3010_fgr.h"
#include "r3010_fcr.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_bus.h"
#include "r3010_forward.h"
#include "r3010_forwarder.h"
#include "r3010.h"
#include "r3010_debug.h"

bool
r3010_stage::pre_mem_exec()
{
	if( inst.is_read() ) {
		return fpa->bus->data_request();
	}

	if (inst.is_write()) {
		return fpa->bus->data_out_request(
			reg[r3010_inst::REG_SRC1].read_word(idx[r3010_inst::REG_SRC1] % 2));
	}

	return true;
}


void
r3010_stage::mem_clock()
{
	r3000_word d;

	switch( mem_state ) {
	case mem_none:
		if( _fpcond.valid ) {
			fpa->csr().set_cond( _fpcond.flag );
		}
		if( inst.is_read() ) {
			mem_state = mem_in;
			goto input;
		}
		if( inst.is_write() ) {
			mem_state = mem_out;
			goto output;
		}
		mem_state = mem_next;
		goto skip;

	case mem_in:
	  input:
		if( !fpa->bus->data_read( &d ) ) {
#ifdef R3010_DEBUG
			if( fpa->debug_level() & R3010_DEBUG_STALL )
				cerr << "MEM: can't receive data.. stall" << endl;
#endif // R3010_DEBUG
			break;
		}

		reg[r3010_inst::REG_DST].write_word(idx[r3010_inst::REG_DST] % 2, d);
		valid[r3010_inst::REG_DST] = true;

		{
			r3010_forward* f = new r3010_forward;

			f->regnum = idx[r3010_inst::REG_DST];
			f->val = reg[r3010_inst::REG_DST];
//			fpa->forward->put(f, 1);
			forward_id[0] = fpa->forward->put(f);
			fpa->release_reg(idx[r3010_inst::REG_DST]);
		}

		mem_state = mem_next;
		goto skip;

	case mem_out:
	  output:
#if 0
		if (!fpa->bus->data_out_request(
				reg[r3010_inst::REG_SRC1].read_word(
					idx[r3010_inst::REG_SRC1] % 2))) {
			break;
		}
#endif
		mem_state = mem_next;

	case mem_next:
	  skip:
		if( fpa->s_wb )
			break;

		fpa->s_wb = this;
		fpa->s_mem = 0;

		stage = wb_stage;
		break;
	}
}
