/*
 * <<< r3010_float_wrapper_test.cc >>>
 *
 * --- Test program for floating point calculation functions
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cmath>
#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <isis/r3000_typedef.h>
#include "r3010_typedef.h"
#include "r3010_float_wrapper.h"

using namespace std;

#define rnd() ((unsigned long)((seed = 1566083941UL * seed + 1) >> 16))
static unsigned long seed = 1;

double double_rand(void);
int single_test(int);
int double_test(int);

int main(int, char** argv)
{
	int count = ((argv[1] != NULL) ? atoi(argv[1]) : 100);
	return ((single_test(count) && double_test(count)) ? 0 : 1);
}

double double_rand(void)
{
	unsigned long x = ((rnd() & 0xff00) | ((rnd() >> 8) & 0xff));
	return double(long(x - 0x8000)) / 0x100;
}

int single_test(int count)
{
	typedef r3010_sfloat float_type;
	union {
		float_type f;
		r3000_word w;
	} src, dst;
	float_type& x = src.f;
	r3000_word& x_word = src.w;
	float_type& y = dst.f;
	r3000_word& y_word = dst.w;
	for (int i = 0; i < count; i++) {
		float_type first_value;
		r3000_word frac[2], x_result, y_result;
		int sign, exp;
		first_value = float_type(double_rand());
		x = first_value;
		sign = r3010_float_wrapper::get_sign(x);
		exp = r3010_float_wrapper::get_exp(x);
		r3010_float_wrapper::get_frac(x, frac);
		y = r3010_float_wrapper::make_single(sign, exp, frac[0]);
		x_result = x_word;
		y_result = y_word;
		if (x_result != y_result) {
			cout << "error ---" << endl
				 << dec << setfill(' ')
				 << "x: " << setw(8) << x
				 << "(0x" << hex << setfill('0') << setw(8) << x_result
				 << ", sign:" << (sign ? '-' : '+')
				 << ", exp:" << dec << setfill('0') << setw(4) << exp
				 << ", frac:0x" << hex << setfill('0') << setw(8) << frac[0]
				 << ')' << endl
				 << dec << setfill(' ')
				 << "y: " << setw(8) << y
				 << "(0x" << hex << setfill('0') << setw(8) << y_result
				 << ')' << endl;
			return 0;
		}
	}
	return 1;
}

int double_test(int count)
{
	typedef r3010_dfloat float_type;
	union {
		float_type f;
		r3000_word w;
	} src, dst;
	float_type& x = src.f;
	r3000_word& x_word = src.w;
	float_type& y = dst.f;
	r3000_word& y_word = dst.w;
	for (int i = 0; i < count; i++) {
		float_type first_value;
		r3000_word frac[2], x_result, y_result;
		int sign, exp;
		first_value = float_type(double_rand());
		x = first_value;
		sign = r3010_float_wrapper::get_sign(x);
		exp = r3010_float_wrapper::get_exp(x);
		r3010_float_wrapper::get_frac(x, frac);
		y = r3010_float_wrapper::make_single(sign, exp, frac[0]);
		x_result = x_word;
		y_result = y_word;
		if (x_result != y_result) {
			cout << "error ---" << endl
				 << dec << setfill(' ')
				 << "x: " << setw(8) << x
				 << "(0x" << hex << setfill('0') << setw(8) << x_result
				 << ", sign:" << (sign ? '-' : '+')
				 << ", exp:" << dec << setfill('0') << setw(4) << exp
				 << ", frac:0x" << hex << setfill('0') << setw(8) << frac[0]
				 << ')' << endl
				 << dec << setfill(' ')
				 << "y: " << setw(8) << y
				 << "(0x" << hex << setfill('0') << setw(8) << y_result
				 << ')' << endl;
			return 0;
		}
	}
	return 1;
}
