/* -*- C++ -*-
 *
 * <<< r3010_float_wrapper_local.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FLOAT_WRAPPER_LOCAL_H
#define R3010_FLOAT_WRAPPER_LOCAL_H

#if HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#ifndef __EXTENSIONS__ /* for Solaris2.6 */
# define __EXTENSIONS__
#endif /* __EXTENSIONS__ */
#ifndef _GNU_SOURCE /* for Linux */
# define _GNU_SOURCE
#endif /* _GNU_SOURCE */
#ifndef _HPUX_SOURCE /* for HPUX */
# define _HPUX_SOURCE
#endif /* _HPUX_SOURCE */
#include <climits>
#include <cfloat>

/* fixed constants */
#define R3000_WORD_LENGTH	32
#define EXP_INFINITY		INT_MAX
#define EXP_ZERO			INT_MIN

/* definition of constants for r3010_sfloat type for R3010 (single precision) */
#if (SIZEOF_FLOAT >= 4)
# define R3010_SFLOAT_IS_FLOAT 1
# undef R3010_SFLOAT_IS_DOUBLE
# define R3010_SFLOAT_MANT_DIG (FLT_MANT_DIG)
# define R3010_SFLOAT_MAX (FLT_MAX)
# define R3010_SFLOAT_MAX_EXP (FLT_MAX_EXP)
#elif (SIZEOF_DOUBLE >= 4)
# undef R3010_SFLOAT_IS_FLOAT
# define R3010_SFLOAT_IS_DOUBLE 1
# define R3010_SFLOAT_MANT_DIG (DBL_MANT_DIG)
# define R3010_SFLOAT_MAX (DBL_MAX)
# define R3010_SFLOAT_MAX_EXP (DBL_MAX_EXP)
#endif

/* definition of constants for r3010_dfloat type for R3010 (double precision) */
#if (SIZEOF_FLOAT >= 8)
# define R3010_DFLOAT_IS_FLOAT 1
# undef R3010_DFLOAT_IS_DOUBLE
# define R3010_DFLOAT_MANT_DIG (FLT_MANT_DIG)
# define R3010_DFLOAT_MAX (FLT_MAX)
# define R3010_DFLOAT_MAX_EXP (FLT_MAX_EXP)
#elif (SIZEOF_DOUBLE >= 8)
# undef R3010_DFLOAT_IS_FLOAT
# define R3010_DFLOAT_IS_DOUBLE 1
# define R3010_DFLOAT_MANT_DIG (DBL_MANT_DIG)
# define R3010_DFLOAT_MAX (DBL_MAX)
# define R3010_DFLOAT_MAX_EXP (DBL_MAX_EXP)
#endif

/* datasize check */
#define CORRECT_R3010_SFLOAT_MAX_EXP	 128
#define CORRECT_R3010_SFLOAT_MANT_DIG	  24
#define CORRECT_R3010_DFLOAT_MAX_EXP	1024
#define CORRECT_R3010_DFLOAT_MANT_DIG	  53
#if R3010_SFLOAT_MAX_EXP != CORRECT_R3010_SFLOAT_MAX_EXP || \
	R3010_DFLOAT_MAX_EXP != CORRECT_R3010_DFLOAT_MAX_EXP || \
	R3010_SFLOAT_MANT_DIG != CORRECT_R3010_SFLOAT_MANT_DIG || \
	R3010_DFLOAT_MANT_DIG != CORRECT_R3010_DFLOAT_MANT_DIG
# error "Sorry, different float variable type was not supported."
#endif

/* calc constants */
#define R3000_INT_LENGTH R3000_WORD_LENGTH
#define R3000_INT_SIGN_LENGTH 1
#define R3000_INT_VALUE_LENGTH (R3000_INT_LENGTH - 1)
#define R3000_INT_SIGN_SHIFT (R3000_INT_LENGTH - 1)
#define R3000_INT_VALUE_SHIFT 0
#define R3000_INT_SIGN_MASK (~0LU << R3000_INT_SIGN_SHIFT)
#define R3000_INT_VALUE_MASK (~(~0LU << R3000_INT_VALUE_LENGTH))
#define R3000_INT_MAX_VALUE	(~(~0LU << R3000_INT_VALUE_LENGTH))
#define R3000_INT_MIN_VALUE	(~0LU << R3000_INT_VALUE_LENGTH)
#define R3010_SFLOAT_LENGTH R3000_WORD_LENGTH
#define R3010_SFLOAT_SIGN_LENGTH 1
#define R3010_SFLOAT_EXP_LENGTH \
	(R3010_SFLOAT_LENGTH - R3010_SFLOAT_SIGN_LENGTH - R3010_SFLOAT_MANT_DIG + 1)
#define R3010_SFLOAT_FRAC_LENGTH (R3010_SFLOAT_MANT_DIG - 1)
#define R3010_SFLOAT_SIGN_SHIFT (R3010_SFLOAT_LENGTH - 1)
#define R3010_SFLOAT_EXP_SHIFT R3010_SFLOAT_FRAC_LENGTH
#define R3010_SFLOAT_FRAC_SHIFT 0
#define R3010_SFLOAT_SIGN_MASK (~0LU << R3010_SFLOAT_SIGN_SHIFT)
#define R3010_SFLOAT_EXP_MASK \
	(~(~0LU << R3010_SFLOAT_EXP_LENGTH) << R3010_SFLOAT_EXP_SHIFT)
#define R3010_SFLOAT_FRAC_MASK (~(~0LU << R3010_SFLOAT_FRAC_LENGTH))
#define R3010_SFLOAT_EXP_BASE (R3010_SFLOAT_MAX_EXP - 1)
#define R3010_SFLOAT_EXP_MAX_VALUE (R3010_SFLOAT_MAX_EXP - 1)
#define R3010_SFLOAT_EXP_MIN_VALUE (2 - R3010_SFLOAT_MAX_EXP)
#define R3010_DFLOAT_LENGTH (R3000_WORD_LENGTH * 2)
#define R3010_DFLOAT_SIGN_LENGTH 1
#define R3010_DFLOAT_EXP_LENGTH \
	(R3010_DFLOAT_LENGTH - R3010_DFLOAT_SIGN_LENGTH - R3010_DFLOAT_MANT_DIG + 1)
#define R3010_DFLOAT_FRAC_LENGTH (R3010_DFLOAT_MANT_DIG - 1)
#define R3010_DFLOAT_SIGN_SHIFT (R3010_DFLOAT_LENGTH - 1)
#define R3010_DFLOAT_EXP_SHIFT R3010_DFLOAT_FRAC_LENGTH
#define R3010_DFLOAT_FRAC_SHIFT 0
#define R3010_DFLOAT_SIGN_SHIFT_HI (R3010_DFLOAT_SIGN_SHIFT - R3000_WORD_LENGTH)
#define R3010_DFLOAT_EXP_SHIFT_HI (R3010_DFLOAT_EXP_SHIFT - R3000_WORD_LENGTH)
#define R3010_DFLOAT_FRAC_SHIFT_HI 0
#define R3010_DFLOAT_FRAC_SHIFT_LO R3010_DFLOAT_FRAC_SHIFT
#define R3010_DFLOAT_SIGN_MASK_HI \
	(~0LU << (R3010_DFLOAT_SIGN_SHIFT - R3000_WORD_LENGTH))
#define R3010_DFLOAT_SIGN_MASK_LO 0
#define R3010_DFLOAT_EXP_MASK_HI \
	(~(~0LU << R3010_DFLOAT_EXP_LENGTH) \
	 << (R3010_DFLOAT_EXP_SHIFT - R3000_WORD_LENGTH))
#define R3010_DFLOAT_EXP_MASK_LO 0
#define R3010_DFLOAT_FRAC_MASK_HI \
	(~(~0LU << (R3010_DFLOAT_FRAC_LENGTH - R3000_WORD_LENGTH)))
#define R3010_DFLOAT_FRAC_MASK_LO (~0)
#define R3010_DFLOAT_EXP_BASE (R3010_DFLOAT_MAX_EXP - 1)
#define R3010_DFLOAT_EXP_MAX_VALUE (R3010_DFLOAT_MAX_EXP - 1)
#define R3010_DFLOAT_EXP_MIN_VALUE (2 - R3010_DFLOAT_MAX_EXP)

#endif /* R3010_FLOAT_WRAPPER_LOCAL_H */
