/* -*- C++ -*-
 *
 * <<< r3010_float_wrapper.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FLOAT_WRAPPER_H
#define R3010_FLOAT_WRAPPER_H 1

#include <isis/r3000_typedef.h>
#include "r3010_typedef.h"

// this class is not a class: to avoid namespace pollusion
class r3010_float_wrapper
{
public:
	enum rm_t {
		ROUND_TO_NEAREST, ROUND_TO_ZERO,
		ROUND_TO_PLUS_INFINITY, ROUND_TO_MINUS_INFINITY
	};
	static int get_sign(r3010_sfloat);
	static int get_exp(r3010_sfloat);
	static void get_frac(r3010_sfloat, r3000_word*);
	static int get_sign(r3010_dfloat);
	static int get_exp(r3010_dfloat);
	static void get_frac(r3010_dfloat, r3000_word*);
	static r3010_sfloat make_single(int /*sign*/, int /*exp*/,
									r3000_word /*frac*/);
	static r3010_dfloat make_double(int /*sign*/, int /*exp*/,
									const r3000_word* /*frac*/);
	static r3010_sfloat word_to_single(r3000_word);
	static r3010_dfloat word_to_double(const r3000_word*);
	static r3000_word single_to_word(r3010_sfloat);
	static void double_to_word(r3010_dfloat, r3000_word*);
	static r3010_dfloat single_to_double(const r3010_sfloat*);
	static void double_to_single(r3010_dfloat, r3010_sfloat*);
	static int get_topbit_index(r3000_word);
};

#endif /* R3010_FLOAT_WRAPPER_H */
