/*
 * <<< r3010_fgr.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iomanip>
#include "r3010_float_wrapper.h"
#include "r3010_fgr.h"
#include "r3010_fgrbuf.h"

using namespace std;

void r3010_fgr::reset(void)
{
	w[0] = w[1] = 0;
	state = fgr_words;
}

r3000_word r3010_fgr::read_word(int idx)
{
	switch (state) {
	case fgr_singles:
		w[0] = r3010_float_wrapper::single_to_word(s[0]);
		w[1] = r3010_float_wrapper::single_to_word(s[1]);
		state = fgr_words;
		break;
	case fgr_double:
		r3010_float_wrapper::double_to_word(d, w);
		state = fgr_words;
		break;
	default:
		break;
	}
	return w[idx % 2];
}

r3010_sfloat r3010_fgr::read_single(int idx)
{
	switch (state) {
	case fgr_words:
		s[0] = r3010_float_wrapper::word_to_single(w[0]);
		s[1] = r3010_float_wrapper::word_to_single(w[1]);
		state = fgr_singles;
		break;
	case fgr_double:
		r3010_float_wrapper::double_to_single(d, s);
		state = fgr_singles;
		break;
	default:
		break;
	}
	return s[idx % 2];
}

r3010_dfloat r3010_fgr::read_double(void)
{
	switch (state) {
	case fgr_words:
		d = r3010_float_wrapper::word_to_double(w);
		state = fgr_double;
		break;
	case fgr_singles:
		d = r3010_float_wrapper::single_to_double(s);
		state = fgr_double;
		break;
	default:
		break;
	}
	return d;
}

void r3010_fgr::write_word(int idx, r3000_word data)
{
	read_word(idx); // make state fgr_words
	w[idx % 2] = data;
}

void r3010_fgr::write_single(int idx, r3010_sfloat data)
{
	read_single(idx); // make state fgr_singles
	s[idx % 2] = data;
}

void r3010_fgr::write_double(r3010_dfloat data)
{
	read_double(); // make state fgr_double
	d = data;
}

ostream& operator<<(ostream& os, const r3010_fgr& fgr)
{
	const ios::fmtflags flags = os.flags();
	switch (fgr.state) {
	case r3010_fgr::fgr_words:
		os << hex << "{ 0x" << fgr.w[0] << ", 0x" << fgr.w[1] << "}";
		break;
	case r3010_fgr::fgr_singles:
		os << "{ " << fgr.s[0] << ", " << fgr.s[1] << "}";
		break;
	case r3010_fgr::fgr_double:
		os << fgr.d;
		break;
	}
	os.flags(flags);
	return os;
}

#if 0
#include <iostream>
#include <iomanip>
int main(void)
{
	r3010_fgrbuf *fgr;
	int i;
	double x;
	static r3000_word d[][2] = {
		{ 0xad6d771c,0xbfee8ec8 },
		{ 0x739e4f68,0xbfe45f30 },
		{ 0x739e4f68,0xbfd45f30 },
		{ 0x00000000,0x00000000 },
		{ 0x739e4f68,0x3fd45f30 },
		{ 0x739e4f68,0x3fe45f30 },
		{ 0xad6d771c,0x3fee8ec8 },
		{ 0x739e4f68,0x3ff45f30 },
	};
	fgr = new r3010_fgrbuf;
	for (i = 0; i < sizeof(d) / sizeof(d[0]); i++) {
		fgr->write_word(2 * i, d[i][0]);
		fgr->write_word(2 * i + 1, d[i][1]);
	}
	for (i = 0; i < sizeof(d) / sizeof(d[0]); i++) {
		x = fgr->read_double(2 * i);
		cout << x << endl;
	}
	return 0;
}
#endif
