/* -*- C++ -*-
 *
 * <<< r3010_ext.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_EXT_H
#define R3010_EXT_H 1

#include <iostream>
#include "r3010_fgr.h"
#include "r3010_forward.h"
#include "r3010_inst.h"

class r3010_base;

class r3010_ext {
protected:
	r3010_base *const fpa;

	int _dst;
	r3010_fgr _val;

	int timer, timer_local;
	enum ext_state_t { ext_idle, ext_calc, ext_wait_adder, ext_delay } state;

	const int delay0_s, delay1_s;
	const int delay0_d, delay1_d;

	bool stall_mode;

public:
	r3010_ext( r3010_base *p, int d0s, int d1s, int d0d, int d1d )
		: fpa(p),
		  delay0_s(d0s), delay1_s(d1s),
		  delay0_d(d0d), delay1_d(d1d) { }
	void reset();

	void clock();

	bool in_use() const { return state != ext_idle; }
	void start(int dst, r3010_fgr& val, r3010_inst::fmt_t type,
			   bool stall = false);

	bool is_stall_mode() const { return stall_mode; }

	friend std::ostream& operator<<(std::ostream&, const r3010_ext&);
};

class r3010_mul : public r3010_ext {
public:
	r3010_mul( r3010_base *p ) : r3010_ext( p, 4, 3, 5, 4 ) { }
};

class r3010_div : public r3010_ext {
public:
	r3010_div( r3010_base *p ) : r3010_ext( p, 12, 9, 19, 16 ) { }
};


#endif /* R3010_EXT_H */
