/* -*- C++ -*-
 *
 * <<< r3010_bus.h >>>
 *
 * --- This file contains declarations of R3010 inner data bus.
 *     Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_BUS_H
#define R3010_BUS_H 1

#include <iostream>
#include <isis/r3000_typedef.h>

class r3010_bus
{
	enum { bus_free, bus_in, bus_out } dir;
	bool valid;
	r3000_word data;
	friend std::ostream& operator<<(std::ostream&, const r3010_bus&);
public:
	r3010_bus();
	void reset();

	// interface between bus and R3010
	bool data_request();
	bool data_read( r3000_word* );
	bool data_out_request( r3000_word );
	// interface between bus and R3000
	bool data_fetch_p();
	void data_fetch( r3000_word );
	bool data_out_p();
	r3000_word data_out();
	void data_out_ok();
};

std::ostream& operator<<(std::ostream&, const r3010_bus&);

#endif /* R3010_BUS_H */
