/*
 * <<< r3010_add.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iomanip>
#include "r3010_add.h"
#include "r3010_fgr.h"
#include "r3010_fgrbuf.h"
#include "r3010_fcr.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_forward.h"
#include "r3010_forwarder.h"
#include "r3010.h"
#include "r3010_debug.h"

using namespace std;

r3010_add::add_wait::add_wait(void)
{
	clear();
}

void
r3010_add::reset()
{
	const int wait_queue_len = sizeof(wait_queue) / sizeof(wait_queue[0]);
	timer = 0;
	state = add_idle;
	for (int i = 0; i < wait_queue_len; i++) {
		wait_queue[i].forward_id[0] = wait_queue[i].forward_id[1] = 0;
		wait_queue[i].regnum = -1;
	}
	stall_mode = false;
}

void
r3010_add::start(int dst, r3010_fgr& val, int time, bool stall)
{
	const int wait_queue_len = sizeof(wait_queue) / sizeof(wait_queue[0]);
	_dst = dst;
	_val = val;
	timer = time;
	ofs = timer - 2;
	if (ofs < 0) ofs = 0;
	if (ofs > wait_queue_len) ofs = -1;
	state = add_calc;
	stall_mode = stall;
}

void
r3010_add::external(int t, r3010_fgr& val, int dst, bool stall)
{
	_dst = dst;
	_val = val;
	timer = t;
	state = add_external;
	stall_mode = stall;
}

void
r3010_add::clock()
{
#if 0
	bool forwarded = false;
#endif
	add_wait *f;
	f = deq();
	if (f->regnum >= 0) {
		writeback(f);
		if (f->forward_id[0]) fpa->forward->del(f->forward_id[0]);
		if (f->forward_id[1]) fpa->forward->del(f->forward_id[1]);
		f->clear();
	}
	switch (state) {
	case add_idle:
		enq(-1, 0);
		break;
	case add_calc:
		if (--timer > 0) {
			enq(-1, 0);
			break;
		}
		state = add_writeback;
	case add_writeback:
		forward();
#if 0
		forwarded = true;
#endif
		enq(_dst, &_val, forward_id[0], forward_id[1], ofs);
		state = add_idle;
		break;
	case add_external:
		/*
		  external mode:
		  all of instructions which calculate need ADDER.
		  this state is for such instructions
		  */
		if (--timer > 0) {
			enq(-1, 0);
			break;
		}
		if (_dst >= 0) {
			{
				r3010_forward f;
				f.regnum = _dst;
				f.val = _val;
				writeback( &f );
				fpa->release_reg(_dst);
				fpa->release_reg(_dst ^ 1);
			}
		}
		state = add_idle;
	}
	queue_step();
#if 0
	if (!forwarded) {
		fpa->forward->put(0);
		fpa->forward->put(0);
	}
#endif
}

void
r3010_add::forward()
{
	r3010_forward *f = new r3010_forward;
	f->regnum =_dst;
	f->val = _val;
//	fpa->forward->put(f, 1);
	forward_id[0] = fpa->forward->put(f);
	f = new r3010_forward;
	f->regnum =_dst ^ 1;
	f->val = _val;
	forward_id[1] = fpa->forward->put(f);
//	fpa->forward->put(f, 1);
#ifdef R3010_DEBUG
	if (fpa->debug_level() & R3010_DEBUG_FORWARDING)
		cerr << "ADD:: forward " << _dst << "&" << (_dst^1) << endl;
#endif // R3010_DEBUG
	fpa->release_reg(_dst);
	fpa->release_reg(_dst ^ 1);
}

void
r3010_add::writeback(r3010_forward* f)
{
#if 0
	fpa->release_reg(f->regnum);
	fpa->release_reg((f->regnum) ^ 1);
#endif
	fpa->fgr().reg( f->regnum ) = f->val;
}

void
r3010_add::enq(int rn, r3010_fgr* v, void* id1, void* id2, int idx) {
	const int wait_queue_len = sizeof(wait_queue) / sizeof(wait_queue[0]);
	int ptr = (queue_pointer + idx) % wait_queue_len;
	wait_queue[ptr].regnum = rn;
	if (v) wait_queue[ptr].val = *v;
	wait_queue[ptr].forward_id[0] = id1;
	wait_queue[ptr].forward_id[1] = id2;
}

ostream&
operator<<(ostream& os, const r3010_add& ad)
{
	const int wait_queue_len = sizeof(ad.wait_queue) / sizeof(ad.wait_queue[0]);
	static char *state_name[] = { "IDLE", "CALC", "WRITEBACK", "EXTERN" };
	os << '{' << state_name[ad.state];
	if (ad.state != r3010_add::add_idle)
		os << '[' << ad.timer << ']';
	if (ad.state != r3010_add::add_idle)
		os << "($f" << ad._dst << '=' << ad._val << ')';
	for (int i = 0; i < wait_queue_len; i++) {
		os << ',' << ad.wait_queue[(ad.queue_pointer + i) % wait_queue_len];
	}
	os << '}';
	return os;
}
