/*
 * <<< inst_test.cc >>>
 *
 * --- Test program for r3010_inst class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iomanip>
#include "r3010_inst.h"

using namespace std;

static r3000_word w[] = {
	//010001 1 0000 00000 00000 00000 000000
	0x46000000,
	//010001 1 0000 00010 00100 00110 000010
	//0100 0110 0000 0010 0010 0001 1000 0010
	0x46022182,
};

int
main()
{
	r3010_inst inst;

	for( unsigned i = 0; i < sizeof(w)/sizeof(w[0]); i++ ) {
		inst.decode( w[i] );
		cout << hex << setw( 8 ) << w[i] << dec << " " << inst << endl;
	}
	return 0;
}
