/*
 * <<< r3000_memory_access_unit_test.cc >>>
 *
 * --- Test program for r3000_memory_access_unit class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include <isis/mapped_memory.h>
#include <isis/memory_control_unit.h>
#include "r3000_typedef.h"
#include "r3000_bus_interface.h"
#include "r3000_cp0_register_file.h"
#include "r3000_memory_access_unit.h"

using namespace std;

typedef r3000_word word;
const size_t sizeof_word = sizeof_r3000_word;

static void read_test(r3000_memory_access_unit&, memory_control_unit<word>&,
					  bus_port<word>&, mapped_memory<word, word>&);
static void write_test(r3000_memory_access_unit&, memory_control_unit<word>&,
					   bus_port<word>&, mapped_memory<word, word>&);

int main(int argc, char** argv)
{
	const word top = (argc > 1) ? atoi(argv[1]) : 0,
			   size = (argc > 2) ? atoi(argv[2]) : 0x100;
	r3000_bus_interface bus_if;
	r3000_cp0_register_file cp0_rf;
	r3000_memory_access_unit ma(bus_if, cp0_rf);
	r3000_directmap_cache data_cache(size / 2, 0x10);
	ma.connect_data_cache(data_cache);
	mapped_memory<word, word> mem_buf(top, size);
	memory_control_unit<word> mem;
	mem.set_read_wait(2);
	mem.set_write_wait(2);
	mem.port_ref().connect(bus_if);
	mem.connect_memory(mem_buf);
	cout << hex;

	write_test(ma, mem, bus_if, mem_buf);
	cout << mem_buf << endl;
	read_test(ma, mem, bus_if, mem_buf);
	cout << data_cache << endl;

	return 0;
}

void write_test(r3000_memory_access_unit& ma, memory_control_unit<word>& mem,
				bus_port<word>& bus_if, mapped_memory<word, word>& mem_buf)
{
	const word top = mem_buf.top(), size = mem_buf.size();
	for (word adr = 0; adr < size; adr += sizeof_word) {
		ma.send_data_write_request(top + adr, adr);
		do {
			cerr << " in: " << bus_if << ", " << ma << endl;
			ma.clock_in();
			mem.clock_in();
			cerr << "out: " << bus_if << ", " << ma << endl;
			ma.clock_out();
			mem.clock_out();
		} while (!ma.data_write_is_ready());
	}
}

void read_test(r3000_memory_access_unit& ma, memory_control_unit<word>& mem,
			   bus_port<word>& bus_if, mapped_memory<word, word>& mem_buf)
{
	const word top = mem_buf.top(), size = mem_buf.size();
	for (word adr = 0; adr < size; adr += sizeof_word * 4) {
		ma.send_multi_data_read_request(top + adr);
		while (1) {
			cerr << " in: " << bus_if << ", " << ma << endl;
			ma.clock_in();
			mem.clock_in();
			if (ma.data_read_is_trans()) break;
			cerr << "out: " << bus_if << ", " << ma << endl;
			ma.clock_out();
			mem.clock_out();
		}
		while (1) {
			cout << "adr:0x" << ma.data_read_address()
				 << " data:0x" << ma.data_read_data() << endl;
			cerr << "out: " << bus_if << ", " << ma << endl;
			ma.clock_out();
			mem.clock_out();
			if (ma.data_read_is_ready()) break;
			cerr << " in: " << bus_if << ", " << ma << endl;
			ma.clock_in();
			mem.clock_in();
		}
	}
}
