/*
 * <<< r3000_instruction_test.cc >>>
 *
 * --- Test program for r3000_instruction class
 *     Copyright (C) 2000-2002 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <fstream>
#include <iostream>
#include <iomanip>
#include "r3000_typedef.h"
#include "mips_executable.h"
#include "r3000_instruction.h"

using namespace std;

int main(int argc, char** argv)
{
	typedef r3000_word word_type;
	const size_t sizeof_word_type = sizeof_r3000_word;
	if (argc == 1) return 1;
	ifstream file;
	mips_executable obj_file;
	mapped_memory<word_type> mem;
	memory_map<word_type> mem_map;
	mem.set_top(0);
	mem.resize(0x20000000);
	mem_map.insert(mem);
	file.open(argv[1]);
	if (!file) return 1;
	obj_file.load_header(file);
	if (!obj_file.is_valid()) return 1;
	obj_file.load_body_to_memory(file, mem_map);
	word_type base = obj_file.entry_point();
	cout << hex << setfill('0');
	for (word_type offset = 0; offset < 0x100; offset += sizeof_word_type) {
		word_type adr = base + offset, dat;
		dat = mem_map.read(adr);
		r3000_instruction inst;
		inst.set(adr, dat);
		cout << setw(8) << adr << ": " << setw(8) << dat << ": ";
		if (inst.is_r_type()) {
			cout << "r - ";
		} else if (inst.is_i_type()) {
			cout << "i - ";
		} else if (inst.is_j_type()) {
			cout << "j - ";
		} else {
			cout << "o - ";
		}
		cout << inst << endl;
	}
	return 0;
}
