/*
 * <<< r3000_cp0_register_file.cc >>>
 *
 * --- R3000 CP0 register file class 'r3000_cp0_register_file'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iomanip>
#include "r3000_cp0_register_file.h"

using namespace std;

r3000_cp0_register_file::r3000_cp0_register_file(void)
{}

r3000_cp0_register_file::r3000_cp0_register_file
	(const r3000_cp0_register_file& a)
	: inherited(a)
{}

r3000_cp0_register_file::~r3000_cp0_register_file()
{}

string r3000_cp0_register_file::register_name(int i)
{
	switch (i) {
	case 0:
		return "index";
		break;
	case 1:
		return "random";
		break;
	case 2:
		return "entrylo";
		break;
	case 4:
		return "context";
		break;
	case 8:
		return "badvaddr";
		break;
	case 10:
		return "entryhi";
		break;
	case 12:
		return "sr";
		break;
	case 13:
		return "cause";
		break;
	case 14:
		return "epc";
		break;
	case 15:
		return "prid";
		break;
	default:
		return "";
	}
}

int r3000_cp0_register_file::register_number(const string& a)
{
	for (size_t i = 0; i < 16; i++) {
		if (register_name(i) == a) return i;
	}
	return -1;
}

void r3000_cp0_register_file::output(ostream& os) const
{
	const char fill = os.fill();
	const ios::fmtflags flags = os.flags();
	os << hex << setfill('0')
	   <<   "sr     : "  << setw(8) << sr()
	   <<  " cause : "   << setw(8) << cause()
	   <<  " epc    : "  << setw(8) << epc()
	   <<  " badvaddr: " << setw(8) << badvaddr()
	   << "\nindex  : "  << setw(8) << index()
	   <<  " random: "   << setw(8) << random()
	   <<  " entryhi: "  << setw(8) << entryhi()
	   <<  " entrylo : " << setw(8) << entrylo()
	   << "\ncontext: "  << setw(8) << context()
	   <<  " prid  : "   << setw(8) << prid();
	os.fill(fill);
	os.flags(flags);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}
