/* -*- C++ -*-
 *
 * <<< r3000_bus_interface.h >>>
 *
 * --- R3000 bus interface class 'r3000_bus_interface'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_BUS_INTERFACE_H
#define R3000_BUS_INTERFACE_H 1

#include <isis/bus_port.h>
#include <isis/r3000_typedef.h>

class r3000_bus_interface : public bus_port<r3000_word, r3000_word>
{
private:
	typedef r3000_bus_interface thisclass;
	typedef bus_port<r3000_word, r3000_word> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::transaction_id_type transaction_id_type;
	r3000_bus_interface(void);
	r3000_bus_interface(const r3000_bus_interface&);
	virtual ~r3000_bus_interface();
	bool is_multi_read_data_last(void) const
		{ return is_multi_read_data() &&
				 packet_number() == total_packet_count() - 1; }
};

#endif /* R3000_BUS_INTERFACE_H */
