/* -*- C++ -*-
 *
 * <<< r3000.h >>>
 *
 * --- R3000 class 'r3000'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_H
#define R3000_H 1

#include <cstddef>
#include <iostream>
#include <string>
#include <isis/port.h>
#include <isis/r3000_typedef.h>
#include <isis/r3000_base.h>

class r3000_directmap_cache;
class r3010;
class r3000_bus_interface;
class r3000_memory_access_unit;
class r3000_write_buffer_unit;
class r3000_integer_unit;
class r3000_cp0;

class r3000 : public r3000_base
{
private:
	typedef r3000 thisclass;
	typedef r3000_base inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	static const size_t sizeof_data_type = inherited::sizeof_data_type;
private:
	r3000_bus_interface* bus_if;
	r3000_cp0* cp0;
	r3000_memory_access_unit* ma_unit;
	r3000_write_buffer_unit* wb_unit;
	r3000_integer_unit* int_unit;
	bool halt_flag_;
	size_t freq_mag_;
public:
	r3000(void);
	r3000(const thisclass&);
	virtual ~r3000();
	virtual void output(std::ostream&) const;
	virtual bool output(std::ostream&, const std::string&) const;
	virtual data_type register_file(size_t) const;
	virtual data_type& register_file(size_t);
	virtual address_type program_counter(void) const;
	virtual address_type& program_counter(void);
	virtual bool is_halt(void) const;
	virtual bool is_stall(void) const;
	virtual bool is_reading(void) const;
	virtual bool is_writing(void) const;
	virtual bool is_user_mode(void) const;
	virtual bool is_kernel_mode(void) const;
	virtual void clock_in(void);
	virtual void clock_out(void);
	virtual void reset(void);
	virtual void halt(void);
	virtual size_t frequency_magnification(void) const;
	virtual void set_frequency_magnification(size_t);
	virtual const port& port_ref(void) const;
	virtual port& port_ref(void);
	virtual bool is_connected_to_instruction_cache(void) const;
	virtual bool is_connected_to_data_cache(void) const;
	virtual bool is_connected_to_coprocessor(void) const;
	virtual void connect_instruction_cache(r3000_directmap_cache&);
	virtual void connect_data_cache(r3000_directmap_cache&);
	virtual void connect_coprocessor(r3010&);
	virtual void disconnect_instruction_cache(void);
	virtual void disconnect_data_cache(void);
	virtual void disconnect_coprocessor(void);
	void enable_streaming(void);
	void disable_streaming(void);
	data_type hi(void) const;
	data_type lo(void) const;
};

#endif /* R3000_H */
