/*
 * <<< virtual_channel_test.cc >>>
 *
 * --- Test program for virtual_channel_input,
 *      			 virtual_channel_output class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include <isis/bus_packet.h>
#include "virtual_channel.h"

using namespace std;

int main(int argc, char** argv)
{
	typedef bus_packet<int> packet_t;
	const int ch_size = (argc > 1) ? atoi(argv[1]) : 4,
			  buf_size = (argc > 2) ? atoi(argv[2]) : 8;
	virtual_channel_input in(ch_size, buf_size);
	virtual_channel_output out;
	in.connect(out);
	if (!in.check_invariant() || !out.check_invariant()) return 1;
	int i;
	for (i = 0; i < ch_size; i++) {
		for (int j = 0; j < i; j++) {
			if (!out.full(i)) {
				packet_t* p = new packet_t;
				p->address() = i + j;
				out.put(i, p);
			}
		}
	}
	cout << "ch:" << ch_size << ", buf:" << buf_size << endl;
	for (i = 0; i < ch_size; i++) {
		cout << "ch" << i << ':';
		while (!in.empty(i)) {
			packet_t* p = (packet_t*)(in.get(i));
			cout << ' ' << p->address();
			delete p;
		}
		cout << endl;
	}
	if (!in.check_invariant() || !out.check_invariant()) return 1;
	in.disconnect();
	if (!in.check_invariant() || !out.check_invariant()) return 1;
	return 0;
}
