/*
 * <<< virtual_channel.cc >>>
 *
 * --- Virtual channel class 'virtual_channel'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <list>
#include <isis/packet.h>
#include "virtual_channel.h"

using namespace std;

virtual_channel_input::virtual_channel_input(void)
	: partner(NULL)
{}

virtual_channel_input::virtual_channel_input(size_t a, size_t b)
	: partner(NULL),
	  buf(a)
{
	set_buffer_size(b);
}

virtual_channel_input::virtual_channel_input(const virtual_channel_input& a)
	: partner(NULL),
	  buf(a.channel_size())
{
	set_buffer_size(a.buffer_size());
}

virtual_channel_input::~virtual_channel_input()
{}

bool virtual_channel_input::check_invariant(void) const
{
	return partner == NULL || partner->is_connected(*this);
}

void virtual_channel_input::connect(virtual_channel_output& a)
{
	if (is_connected()) disconnect();
	if (a.is_connected()) disconnect();
	partner = &a;
	a.partner = this;
}

void virtual_channel_input::disconnect(void)
{
	if (!is_connected()) return;
	partner->partner = NULL;
	partner = NULL;
}

void virtual_channel_input::set_channel_size(size_t a)
{
	clear();
	if (a >= 0) {
		const int buf_size = buffer_size();
		buf.resize(a);
		set_buffer_size(buf_size);
	}
}

void virtual_channel_input::set_buffer_size(size_t a)
{
	clear();
	if (a >= 0) {
		for (size_t i = 0; i < channel_size(); i++) buf[i].reserve(a);
	}
}

void virtual_channel_input::clear(size_t a)
{
	buf[a].clear();
}

void virtual_channel_input::clear(void)
{
	for (size_t i = 0; i < channel_size(); i++) clear(i);
}

void virtual_channel_input::output(ostream& os) const
{
	for (size_t i = 0; i < channel_size(); i++) {
		cyclic_queue<packet*> tmp_que(buf[i]);
		list<const packet*> tmp;
		while (!tmp_que.empty()) {
			tmp.push_front(tmp_que.front());
			tmp_que.pop();
		}
		list<const packet*>::const_iterator p = tmp.begin();
		os << '[';
		while (p != tmp.end()) {
			const packet* pkt = *p;
			p++;
			if (p != tmp.end()) {
				if (pkt == *p) {
					os << ':';
				} else {
					os << *pkt << ',';
				}
			} else {
				os << *pkt;
			}
		}
		os << ']';
	}
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

virtual_channel_output::virtual_channel_output(void)
	: partner(NULL)
{}

virtual_channel_output::virtual_channel_output(const virtual_channel_output&)
	: partner(NULL)
{}

virtual_channel_output::~virtual_channel_output()
{}

bool virtual_channel_output::check_invariant(void) const
{
	return partner == NULL || partner->is_connected(*this);
}

void virtual_channel_output::output(ostream& os) const
{
	if (!is_connected()) {
		os << "not connected";
	} else {
		partner->output(os);
	}
}
