/*
 * <<< port_test.cc >>>
 *
 * --- Test program for port class
 *     Copyright (C) 2000-2003 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "port.h"

using namespace std;

int check_and_show(const port&, const port&, const port&, const port&);

int check_and_show(const port& a, const port& b, const port& c, const port& d)
{
	if (!a.check_invariant() || !b.check_invariant() ||
		!c.check_invariant() || !d.check_invariant())
		return 0;
	cout << "a: " << a << endl << "b: " << b << endl
		 << "c: " << c << endl << "d: " << d << endl;
	return 1;
}

int main(void)
{
	port a;
	port b;
	port c;
	port d;
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "a.connect(b);" << endl;
	a.connect(b);
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "c.connect(d);" << endl;
	c.connect(d);
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "a.connect(c);" << endl;
	a.connect(c);
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "b.set_id(2);" << endl;
	b.set_id(2);
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "a.set_id(0), b.set_id(1), c.set_id(2), d.set_id(3);" << endl;
	a.set_id(0), b.set_id(1), c.set_id(2), d.set_id(3);
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "a.request_ownership();" << endl;
	cout << "b.request_ownership();" << endl;
	a.request_ownership();
	b.request_ownership();
	cout << "a is " << (a.is_owner() ? "owner" : "not owner") << endl;
	cout << "b is " << (b.is_owner() ? "owner" : "not owner") << endl;
	cout << "c is " << (c.is_owner() ? "owner" : "not owner") << endl;
	cout << "d is " << (d.is_owner() ? "owner" : "not owner") << endl;

	cout << "a.release_ownership();" << endl;
	cout << "b.release_ownership();" << endl;
	cout << "a.request_ownership();" << endl;
	cout << "c.request_ownership();" << endl;
	a.release_ownership();
	b.release_ownership();
	a.request_ownership();
	c.request_ownership();
	cout << "a is " << (a.is_owner() ? "owner" : "not owner") << endl;
	cout << "b is " << (b.is_owner() ? "owner" : "not owner") << endl;
	cout << "c is " << (c.is_owner() ? "owner" : "not owner") << endl;
	cout << "d is " << (d.is_owner() ? "owner" : "not owner") << endl;

	cout << "a.release_ownership();" << endl;
	cout << "c.release_ownership();" << endl;
	cout << "a.request_ownership();" << endl;
	cout << "c.request_ownership();" << endl;
	cout << "d.request_ownership();" << endl;
	a.release_ownership();
	c.release_ownership();
	a.request_ownership();
	c.request_ownership();
	d.request_ownership();
	cout << "a is " << (a.is_owner() ? "owner" : "not owner") << endl;
	cout << "b is " << (b.is_owner() ? "owner" : "not owner") << endl;
	cout << "c is " << (c.is_owner() ? "owner" : "not owner") << endl;
	cout << "d is " << (d.is_owner() ? "owner" : "not owner") << endl;

	cout << "a.set_number_of_arbiter(2);" << endl;
	a.set_number_of_arbiter(2);
	cout << "a.request_ownership(0);" << endl;
	cout << "b.request_ownership(1);" << endl;
	cout << "c.request_ownership(0);" << endl;
	cout << "d.request_ownership(1);" << endl;
	a.request_ownership(0);
	b.request_ownership(1);
	c.request_ownership(0);
	d.request_ownership(1);
	cout << "a is " << (a.is_owner(0) ? "owner" : "not owner") << "(0)" << endl;
	cout << "a is " << (a.is_owner(1) ? "owner" : "not owner") << "(1)" << endl;
	cout << "b is " << (b.is_owner(0) ? "owner" : "not owner") << "(0)" << endl;
	cout << "b is " << (b.is_owner(1) ? "owner" : "not owner") << "(1)" << endl;
	cout << "c is " << (c.is_owner(0) ? "owner" : "not owner") << "(0)" << endl;
	cout << "c is " << (c.is_owner(1) ? "owner" : "not owner") << "(1)" << endl;
	cout << "d is " << (d.is_owner(0) ? "owner" : "not owner") << "(0)" << endl;
	cout << "d is " << (d.is_owner(1) ? "owner" : "not owner") << "(1)" << endl;

	cout << "c.disconnect();" << endl;
	c.disconnect();
	if (!check_and_show(a, b, c, d)) return 1;

	cout << "d.disconnect();" << endl;
	d.disconnect();
	if (!check_and_show(a, b, c, d)) return 1;

	return 0;
}
