/* -*- C++ -*-
 *
 * <<< simple_cache_line.h >>>
 *
 * --- Simple cache line class 'simple_cache_line'
 *     Copyright (C) 1995-2003 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SIMPLE_CACHE_LINE_H
#define SIMPLE_CACHE_LINE_H 1

#include <cstddef>
#include <vector>
#include <iostream>
#include <iomanip>
#include <isis/cache_line_base.h>

template <
	typename address_type,
	typename data_type = address_type,
	class container_type = std::vector<data_type>
>
class simple_cache_line;

template <typename A, typename D, class C>
class simple_cache_line : public cache_line_base<A, D, C>
{
private:
	typedef simple_cache_line<A, D, C> self_type;
	typedef cache_line_base<A, D, C> base_type;
	typedef C container_type;
public:
	typedef A address_type;
	typedef D data_type;
	typedef typename container_type::size_type size_type;
	//
	explicit simple_cache_line(
		size_type, address_type = address_type(0), data_type = data_type(0)
	);
	simple_cache_line(const self_type&);
	virtual ~simple_cache_line();
	void swap(self_type&);
	self_type& operator=(const self_type&);
	virtual void output(std::ostream&) const;
	virtual bool is_valid() const
		{ return valid_flag_; }
	void set_valid()
		{ valid_flag_ = true; }
	void set_invalid()
		{ valid_flag_ = false; }
private:
	bool valid_flag_;
	//
	// forbidden
	simple_cache_line();
};

template <typename A, typename D, class C>
simple_cache_line<A, D, C>::simple_cache_line(
	simple_cache_line<A, D, C>::size_type n,
	simple_cache_line<A, D, C>::address_type adr,
	simple_cache_line<A, D, C>::data_type dat
)
	:
	base_type(n, adr, dat),
	valid_flag_(false)
{}

template <typename A, typename D, class C>
simple_cache_line<A, D, C>::simple_cache_line(
	const simple_cache_line<A, D, C>& a
)
	:
	base_type(a),
	valid_flag_(a.valid_flag_)
{}

template <typename A, typename D, class C>
simple_cache_line<A, D, C>::~simple_cache_line()
{}

template <typename A, typename D, class C>
void simple_cache_line<A, D, C>::swap(simple_cache_line<A, D, C>& a)
{
	base_type::swap(a);
	std::swap(valid_flag_, a.valid_flag_);
}

template <typename A, typename D, class C>
simple_cache_line<A, D, C>& simple_cache_line<A, D, C>::operator=(
	const simple_cache_line<A, D, C>& a
)
{
	if (this != &a) self_type(a).swap(*this);
	return *this;
}

template <typename A, typename D, class C>
void simple_cache_line<A, D, C>::output(std::ostream& os) const
{
	using namespace std;
	//
	if (!os) return;
	const char fill = os.fill();
	const ios::fmtflags flags = os.flags();
	os << hex << setfill('0');
	if (!is_valid()) {
		os << "<invalid>";
	} else {
		os << setw(sizeof(address_type) * 2) << tag() << ':';
		for (size_type i = 0; i < size(); i++) {
			os << ' ' << setw(sizeof(data_type) * 2) << data(i);
		}
	}
	os.fill(fill);
	os.flags(flags);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

#endif // SIMPLE_CACHE_LINE_H
