/*
 * <<< set_associative_cache_test.cc >>>
 *
 * --- Test program for set_associative_cache class
 *     Copyright (C) 2000-2003 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include <iomanip>
#include "simple_cache_line.h"
#include "set_associative_cache.h"

typedef unsigned int word_type;
typedef simple_cache_line<word_type, word_type> cache_line_type;
typedef cache_line_set<cache_line_type> cache_line_set_type;
typedef set_associative_cache<cache_line_type> cache_type;

inline word_type word_random(void)
{
	static unsigned long seed;
	return seed = 1566083941UL * seed + 1;
}

int main(int argc, const char* const* argv)
{
	using namespace std;
	//
	size_t cache_size = 0x100, line_size = 0x10, way_size = 4, count = 10;
	//
	while (*++argv && **argv == '-') {
		switch (*(*argv + 1)) {
		case 'c': cache_size = strtoul(*argv + 2, 0, 0); break;
		case 'l': line_size = strtoul(*argv + 2, 0, 0); break;
		case 'w': way_size = strtoul(*argv + 2, 0, 0); break;
		case 'n': count = strtoul(*argv + 2, 0, 0); break;
		default: break;
		}
	}
	//
	cache_type cc(cache_size, line_size, way_size);
	//
	cerr << setfill('0');
	for (size_t i = 0; i < count; i++) {
		word_type adr = cc.tag_address((word_random() >> 23) & 0x1ff);
		cerr << "#:0x" << hex << setw(4) << i
		     << " adr:0x" << setw(4) << adr << ' ';
		cache_line_set_type& cls = cc.cache_line_set(adr);
		cache_line_type* cl;
		int way_index = cls.way_of_hit(adr);
		bool hit_flag = false;
		if (way_index >= 0) {
			// hit
			cls.increment_lru_counter(way_index);
			hit_flag = true;
			cerr << "hit ";
		} else if (cls.is_full()) {
			// full
			way_index = cls.way_of_throw();
			cls.clear_lru_counter(way_index);
			cerr << "repl";
		} else {
			// not full but miss
			way_index = cls.way_of_empty();
			cerr << "miss";
		}
		cerr << " - " << dec << way_index << endl;
		cl = &cls[way_index];
		cl->set_valid();
		cl->set_tag(adr);
		if (!hit_flag) {
			for (size_t j = 0; j < cl->size(); j++) cl->set_data(j, i);
		}
	}
	cout << cc << endl;
	return 0;
}
