/*
 * <<< instruction_buffer_test.cc >>>
 *
 * --- Test program for instruction_buffer class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "instruction_buffer.h"

using namespace std;

class inst
{
private:
	char c;
public:
	inst(void) : c('-') {}
	void fetch(char a) { c = a; }
	void clear(void) { c = '-'; }
	void output(ostream& os) const { os << c; }
};

ostream& operator<<(ostream& os, const inst& a)
{
	if (os) a.output(os);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
	return os;
}

int main(void)
{
	const char inst_stream[] = {
		'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
		'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
		'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
		'y', 'z'
	};
	const size_t size = 10;
	typedef instruction_buffer<inst> container_type;
	typedef container_type::size_type size_type;
	container_type ibuf(size);
	for (size_type i = 0; i < sizeof(inst_stream) + size - 1; i++) {
		if (i < sizeof(inst_stream)) {
			ibuf[0].fetch(inst_stream[i]);
		} else {
			ibuf[0].clear();
		}
		for (size_type j = 0; j < ibuf.size(); j++) cout << ibuf[j] << ' ';
		cout << endl;
		ibuf.step();
	}
	return 0;
}
