/* -*- C++ -*-
 *
 * <<< fileio_map.h >>>
 *
 * --- Pseudo file I/O map class 'fileio_map'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef FILEIO_MAP_H
#define FILEIO_MAP_H 1

#include <fstream>
#include <iostream>
#include <vector>

class fileio_map
{
private:
	class entry
	{
	private:
		enum {
			readable_mask = 0x01,
			writable_mask = 0x02,
			opened_mask	  = 0x04
		};
		void* fp;
		int flags_;
	public:
		entry(void);
		~entry();
		int flags(void) const { return flags_; }
		bool is_readable(void) const { return flags_ & readable_mask; }
		bool is_writable(void) const { return flags_ & writable_mask; }
		bool is_opened(void) const { return flags_ & opened_mask; }
		const std::istream& input_stream(void) const
			{ return is_opened() ? *(std::fstream*)fp : *(std::istream*)fp; }
		const std::ostream& output_stream(void) const
			{ return is_opened() ? *(std::fstream*)fp : *(std::ostream*)fp; }
		std::istream& input_stream(void)
			{ return is_opened() ? *(std::fstream*)fp : *(std::istream*)fp; }
		std::ostream& output_stream(void)
			{ return is_opened() ? *(std::fstream*)fp : *(std::ostream*)fp; }
		void set_input_stream(std::istream& a)
			{ fp = &a, flags_ = readable_mask; }
		void set_output_stream(std::ostream& a)
			{ fp = &a, flags_ = writable_mask; }
		bool open(const char*, int);
		bool close(void);
		bool eof(void) const { return input_stream().eof(); }
		bool good_input_stream(void) const { return input_stream().good(); }
		bool good_output_stream(void) const { return output_stream().good(); }
		bool put(char a)
			{ return output_stream().put(a) ? true : false; }
		bool get(char& a)
			{ return input_stream().get(a) ? true : false; }
		long seek(long, int);
		void flush(void) { output_stream().flush(); }
		void clear(void);
		void force_clear_open_flag(void) { flags_ &= ~opened_mask; }
	};
	typedef fileio_map thisclass;
	std::vector<entry> buf;
public:
	fileio_map(void);
	explicit fileio_map(size_t);
	fileio_map(const thisclass&);
	~fileio_map();
	void set_standard_io(void);
	size_t size(void) const { return buf.size(); }
	void resize(size_t a) { buf.resize(a); }
	bool is_readable(size_t a) const { return buf[a].is_readable(); }
	bool is_writable(size_t a) const { return buf[a].is_writable(); }
	bool is_opened(size_t a) const { return buf[a].is_opened(); }
	void set_input_stream(size_t a, std::istream& b)
		{ buf[a].set_input_stream(b); }
	void set_output_stream(size_t a, std::ostream& b)
		{ buf[a].set_output_stream(b); }
	bool open(size_t, const char*, int);
	bool close(size_t);
	bool eof(size_t a) const { return buf[a].eof(); }
	bool good_input_stream(size_t a) const
		{ return buf[a].good_input_stream(); }
	bool good_output_stream(size_t a) const
		{ return buf[a].good_output_stream(); }
	bool put(size_t a, char b) { return buf[a].put(b) ? true : false; }
	bool get(size_t a, char& b) { return buf[a].get(b) ? true : false; }
	long seek(size_t a, long b, int c) { return buf[a].seek(b, c); }
	void flush(size_t a) { buf[a].flush(); }
};

#endif /* FILEIO_MAP_H */
