/*
 * <<< crossbar.cc >>>
 *
 * --- Crossbar class 'crossbar'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <algorithm>
#include "crossbar.h"

crossbar::crossbar(void)
	: in_size_(0),
	  out_size_(0),
	  i2o_size_(0),
	  o2i_flag_(0),
	  i2o_tbl_(0),
	  o2i_tbl_(0)
{}

crossbar::crossbar(size_t i, size_t j)
	: in_size_(i),
	  out_size_(j),
	  i2o_size_(i),
	  o2i_flag_(j),
	  i2o_tbl_(i * j),
	  o2i_tbl_(j)
{
	clear();
}

crossbar::crossbar(const crossbar& a)
	: in_size_(a.in_size_),
	  out_size_(a.out_size_),
	  i2o_size_(a.i2o_size_),
	  o2i_flag_(a.o2i_flag_),
	  i2o_tbl_(a.i2o_tbl_),
	  o2i_tbl_(a.o2i_tbl_)
{}

void crossbar::resize(size_t i, size_t j)
{
	in_size_ = i;
	out_size_ = j;
	i2o_size_.resize(i);
	o2i_flag_.resize(j);
	i2o_tbl_.resize(i * j);
	o2i_tbl_.resize(j);
	clear();
}

void crossbar::clear(void)
{
	fill(i2o_size_.begin(), i2o_size_.end(), 0);
	fill(o2i_flag_.begin(), o2i_flag_.end(), false);
}
