/* -*- C++ -*-
 *
 * <<< argument_map.h >>>
 *
 * --- Command-line argument interface class 'argument_map'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef ARGUMENT_MAP_H
#define ARGUMENT_MAP_H 1

#ifdef DEBUG
# include <cassert>
#endif // DEBUG
#include <iostream>

class argument_map
{
private:
	typedef argument_map thisclass;
	size_t argc_;
	const char** argv_;
	void assign(const thisclass&);
public:
	argument_map(void);
	explicit argument_map(const char* const*);
	argument_map(const thisclass&);
	~argument_map();
	thisclass& operator=(const thisclass&);
	void output(std::ostream&) const;
	int argc(void) const { return int(argc_); }
	inline const char* argv(size_t) const;
	void set(const char* const*);
	void clear(void);
};

std::ostream& operator<<(std::ostream&, const argument_map&);

inline const char* argument_map::argv(size_t i) const
{
#ifdef DEBUG
	assert(i < argc_);
#endif // DEBUG
	return argv_[i];
}

#endif /* ARGUMENT_MAP_H */
