/* -*- C++ -*-
 *
 * <<< argument_map.cc >>>
 *
 * --- Command-line argument interface class 'argument_map'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring>
#include "argument_map.h"

using namespace std;

argument_map::argument_map(void)
	: argc_(0),
	  argv_(NULL)
{}

argument_map::argument_map(const char* const* a)
	: argc_(0),
	  argv_(NULL)
{
	set(a);
}

argument_map::argument_map(const argument_map& a)
{
	assign(a);
}

argument_map::~argument_map()
{
	clear();
}

argument_map& argument_map::operator=(const argument_map& a)
{
	if (&a != this) {
		clear();
		assign(a);
	}
	return *this;
}

void argument_map::assign(const argument_map& a)
{
	argc_ = a.argc_;
	if (argc_ > 0) {
		argv_ = new const char*[argc_];
		for (size_t i = 0; i < argc_; i++) {
			size_t len = size_t(strlen(a.argv_[i]));
			char* p = new char[len + 1];
			strncpy(p, a.argv_[i], len + 1);
			argv_[i] = (const char*)(p);
		}
	} else {
		argv_ = NULL;
	}
}

void argument_map::set(const char* const* a)
{
	clear();
	if (a == NULL) return;
	size_t i = 0;
	while (a[i] != NULL) i++;
	if (i == 0) return;
	argc_ = i;
	argv_ = new const char*[argc_];
	for (i = 0; i < argc_; i++) {
		size_t len = size_t(strlen(a[i]));
		char* p = new char[len + 1];
		strncpy(p, a[i], len + 1);
		argv_[i] = (const char*)(p);
	}
}

void argument_map::clear(void)
{
	if (argc_ > 0) {
		for (size_t i = 0; i < argc_; i++) delete[] argv_[i];
		delete[] argv_;
		argc_ = 0;
		argv_ = NULL;
	}
}

void argument_map::output(ostream& os) const
{
	if (argc_ == 0) return;
	for (size_t i = 0; i < argc_; i++) {
		if (i > 0) os << ' ';
		os << argv_[i];
	}
}

ostream& operator<<(ostream& os, const argument_map& a)
{
	if (os) a.output(os);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
	return os;
}
