dnl Test for ISIS, and define ISIS_CFLAGS and ISIS_LIBS.
dnl CF_PATH_ISIS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
AC_DEFUN(CF_PATH_ISIS, [
  dnl Get the cflags and libraries from the isis-config script
  dnl
  AC_ARG_WITH(
    isis-prefix,
    [  --with-isis-prefix=PFX      Prefix where ISIS is installed (optional)],
    isis_config_prefix="$withval",
    isis_config_prefix=""
  )
  AC_ARG_WITH(
    isis-exec-prefix,
    [  --with-isis-exec-prefix=PFX Exec prefix where ISIS is installed (optional)],
    isis_config_exec_prefix="$withval",
    isis_config_exec_prefix=""
  )
  AC_ARG_ENABLE(
    isistest,
    [  --disable-isistest          Do not try to compile and run a test ISIS program],
    ,
    enable_isistest=yes
  )
  if test x$isis_config_exec_prefix != x ; then
    isis_config_args="$isis_config_args --exec-prefix=$isis_config_exec_prefix"
    if test x${ISIS_CONFIG+set} != xset ; then
      ISIS_CONFIG=$isis_config_exec_prefix/bin/isis-config
    fi
  fi
  if test x$isis_config_prefix != x ; then
    isis_config_args="$isis_config_args --prefix=$isis_config_prefix"
    if test x${ISIS_CONFIG+set} != xset ; then
      ISIS_CONFIG=$isis_config_prefix/bin/isis-config
    fi
  fi
  AC_PATH_PROG(ISIS_CONFIG, isis-config, no)
  min_isis_version=ifelse([$1], , 1.0.0, $1)
  AC_MSG_CHECKING(for ISIS - version >= $min_isis_version)
  no_isis=""
  if test "$ISIS_CONFIG" = "no" ; then
    no_isis=yes
  else
    ISIS_CFLAGS=`$ISIS_CONFIG $isis_config_args --cflags`
    ISIS_LIBS=`$ISIS_CONFIG $isis_config_args --libs`
    isis_config_major_version=`$ISIS_CONFIG $isis_config_args --version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    isis_config_minor_version=`$ISIS_CONFIG $isis_config_args --version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    isis_config_micro_version=`$ISIS_CONFIG $isis_config_args --version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    min_isis_major_version=`echo $min_isis_version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    min_isis_minor_version=`echo $min_isis_version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    min_isis_micro_version=`echo $min_isis_version \
    | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_isistest" = "xyes" ; then
      dnl
      dnl Now check if the installed ISIS is sufficiently new.
      dnl (Also sanity checks the results of isis-config to some extent)
      dnl
      rm -f conf.isistest
      AC_LANG_SAVE
      AC_LANG_CPLUSPLUS
      ac_save_CXXFLAGS="$CXXFLAGS"
      ac_save_LIBS="$LIBS"
      CXXFLAGS="$CXXFLAGS $ISIS_CFLAGS"
      LIBS="$ISIS_LIBS $LIBS"
      AC_TRY_RUN([
#include <cstdlib>
#include <iostream>
#include <isis/isis.h>
int main(void)
{
  system("touch conf.isistest");
  int header_major_version = ISIS_MAJOR_VERSION;
  int header_minor_version = ISIS_MINOR_VERSION;
  int header_micro_version = ISIS_MICRO_VERSION;
  int library_major_version = isis::major_version();
  int library_minor_version = isis::minor_version();
  int library_micro_version = isis::micro_version();
  int config_major_version = $isis_config_major_version;
  int config_minor_version = $isis_config_minor_version;
  int config_micro_version = $isis_config_micro_version;
  int required_major_version = $min_isis_major_version;
  int required_minor_version = $min_isis_minor_version;
  int required_micro_version = $min_isis_micro_version;
  if ((library_major_version != config_major_version) ||
      (library_minor_version != config_minor_version) ||
      (library_micro_version != config_micro_version)) {
    cout
    << endl
    << "*** \`isis-config --version' returned "
    << config_major_version << '.'
    << config_minor_version << '.'
    << config_micro_version
    << ", but ISIS ("
    << library_major_version << '.'
    << library_minor_version << '.'
    << library_micro_version
    << ") was found!" << endl
    << "*** If isis-config was correct, then it is best to remove the old version" << endl
    << "*** of ISIS.  You may also be able to fix the error by modifying your" << endl
    << "*** LD_LIBRARY_PATH enviroment variable, or by editing /etc/ld.so.conf." << endl
    << "*** Make sure you have run ldconfig if that is required on your system." << endl
    << "*** If isis-config was wrong, set the environment variable ISIS_CONFIG to" << endl
    << "*** point to the correct copy of isis-config, and remove the file" << endl
    << "*** config.cache before re-running configure." << endl;
  } else if ((library_major_version != header_major_version) ||
             (library_minor_version != header_minor_version) ||
             (library_micro_version != header_micro_version)) {
    cout
    << endl
    << "*** ISIS header files (version "
    << header_major_version << '.'
    << header_minor_version << '.'
    << header_micro_version
    << ") " << "do not match library (version "
    << library_major_version << '.'
    << library_minor_version << '.'
    << library_micro_version
    << ")." << endl;
  } else {
    if ((library_major_version > required_major_version) ||
        ((library_major_version == required_major_version) &&
         (library_minor_version > required_minor_version)) ||
        ((library_major_version == required_major_version) &&
         (library_minor_version == required_minor_version) &&
         (library_micro_version >= required_micro_version))) {
      return 0;
    } else {
      cout
      << endl
      << "*** An old version of ISIS ("
      << library_major_version << '.'
      << library_minor_version << '.'
      << library_micro_version
      << ") " << "was found.  You need a version of ISIS" << endl
      << "*** newer than "
      << required_major_version << '.'
      << required_minor_version << '.'
      << required_micro_version
      << '.' << endl
      << "***" << endl
      << "*** If you have already installed a sufficiently new version, this error" << endl
      << "*** probably means that the wrong copy of the isis-config shell script is" << endl
      << "*** being found.  The easiest way to fix this is to remove the old version" << endl
      << "*** of ISIS, but you can also set the ISIS_CONFIG environment to point to" << endl
      << "*** the correct copy of isis-config.  In this case, you will have to modify" << endl
      << "*** your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf so" << endl
      << "*** that the correct libraries are found at run-time." << endl;
    }
  }
  return 1;
}
],
      , no_isis=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])
      CXXFLAGS="$ac_save_CXXFLAGS"
      LIBS="$ac_save_LIBS"
      AC_LANG_RESTORE
    fi
  fi
  if test "x$no_isis" = x ; then
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])     
  else
    AC_MSG_RESULT(no)
    if test "$ISIS_CONFIG" = "no" ; then
      echo "*** The isis-config script installed by ISIS could not be found"
      echo "*** If ISIS was installed in PREFIX, make sure PREFIX/bin is in"
      echo "*** your path, or set the ISIS_CONFIG environment variable to the"
      echo "*** full path to isis-config."
    else
      if test -f conf.isistest ; then
        :
      else
        echo "*** Could not run ISIS test program, checking why..."
        AC_LANG_SAVE
        AC_LANG_CPLUSPLUS
        CXXFLAGS="$CXXFLAGS $ISIS_CFLAGS"
        LIBS="$LIBS $ISIS_LIBS"
        AC_TRY_LINK([
#include <iostream>
#include <isis/isis.h>
], [
return isis::major_version() || isis::minor_version() || isis::micro_version();
], [
echo "*** The test program compiled, but did not run. This usually means"
echo "*** that the run-time linker is not finding ISIS or finding the wrong"
echo "*** version of ISIS. If it is not finding ISIS, you'll need to set your"
echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
echo "*** to the installed location  Also, make sure you have run ldconfig if that"
echo "*** is required on your system"
echo "***"
echo "*** If you have an old version installed, it is best to remove it, although"
echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
], [
echo "*** The test program failed to compile or link. See the file config.log for the"
echo "*** exact error that occured. This usually means ISIS was incorrectly installed"
echo "*** or that you have moved ISIS since it was installed. In the latter case, you"
echo "*** may want to edit the isis-config script: $ISIS_CONFIG"
])
        CXXFLAGS="$ac_save_CXXFLAGS"
        LIBS="$ac_save_LIBS"
        AC_LANG_RESTORE
      fi
    fi
    ISIS_CFLAGS=""
    ISIS_LIBS=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(ISIS_CFLAGS)
  AC_SUBST(ISIS_LIBS)
  rm -f conf.isistest
])
