/* -*- C++ -*-
 * Copyright (c) 1995-1996 Tohru Kisuki
 *               1995-2001 Masaki Wakabayashi
 *               1998 Keisuke Inoue
 *      	 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */
/*
 * <<< snoop_cache.h >>>
 * snoop cache architecture
 */

#ifndef SNOOP_CACHE_H
#define SNOOP_CACHE_H

// #include <vector>
#include <isis/array.h>
#include <isis/isis.h>
#include "bus_bridge.h"
#include "snoop_cache_element.h"

class ostream;

class snoop_cache : public multiprocessor<snoop_cache_element>
{
private:
	typedef snoop_cache thisclass;
	typedef multiprocessor<snoop_cache_element> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	typedef inherited::processor_type processor_type;
	typedef inherited::memory_map_type memory_map_type;
	typedef snoop_cache_element processing_element_type;
	static const size_t sizeof_word_type = sizeof_r3000_word;
	typedef mapped_memory<address_type, data_type, sizeof_word_type, char_type>
		mapped_memory_type;
private:
	array<processing_element_type> pe;
	mapped_memory_type shmem, symem;
	memory_control_unit<address_type, data_type, sizeof_word_type, char_type>
		shmem_ctl, symem_ctl;
	bus_bridge<data_type> bus_if;
	arbiter sender;						// åž
public:
	snoop_cache();
	explicit snoop_cache(size_t);
	snoop_cache(const snoop_cache&);
	virtual ~snoop_cache() {}
	virtual void output(ostream&) const;
	virtual const processing_element_type& processing_element(size_t i) const {
		return pe[i]; }
	virtual processing_element_type& processing_element(size_t i) {
		return pe[i]; }
	virtual const processing_element_type& processing_element_actual(size_t i)
		const {
		return pe[i]; }
	virtual processing_element_type& processing_element_actual(size_t i) {
		return pe[i]; }
	virtual size_t processor_number() const {
		return pe.size(); }
	virtual void set_processor_number(size_t);
	address_type shared_memory_address(void) const { return shmem.top(); }
	size_type shared_memory_size(void) const { return shmem.size(); }
	address_type sync_memory_address(void) const { return symem.top(); }
	size_type sync_memory_size(void) const { return symem.size(); }
	void set_shared_memory_area(address_type, size_type);
	void set_sync_memory_area(address_type, size_type);
	void enable_coprocessor();
	void enable_instruction_cache();
	void enable_data_cache();
	void disable_coprocessor();
	void disable_instruction_cache();
	void disable_data_cache();
	unsigned int shared_memory_read_wait() const {
		return shmem_ctl.read_wait(); }
	unsigned int shared_memory_write_wait() const {
		return shmem_ctl.write_wait(); }
	unsigned int sync_memory_read_wait() const {
		return symem_ctl.read_wait(); }
	unsigned int sync_memory_write_wait() const {
		return symem_ctl.write_wait(); }
	void shared_memory_read_wait(unsigned int);
	void shared_memory_write_wait(unsigned int);
	void sync_memory_read_wait(unsigned int);
	void sync_memory_write_wait(unsigned int);
	void set_cache_size(size_type, size_type, size_t);
	void enable_trace(ostream& = cout);
	void disable_trace();
};

#endif // SNOOP_CACHE_H
