/*
 * <<< synchronous_unit_set.cc >>>
 *
 * --- Abstract set of synchronous unit class 'synchronous_unit_set'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <algorithm>
#include "synchronous_unit_set.h"

synchronous_unit_set::synchronous_unit_set(void)
	: unit_table_()
{}

synchronous_unit_set::synchronous_unit_set(const synchronous_unit_set&)
	: unit_table_()
{}

synchronous_unit_set::~synchronous_unit_set(void)
{}

void synchronous_unit_set::insert_synchronous_unit(synchronous_unit& a)
{
	unit_table_.push_back(&a);
}

void synchronous_unit_set::erase_synchronous_unit(synchronous_unit& a)
{
	remove(unit_table_.begin(), unit_table_.end(), &a);
}

void synchronous_unit_set::insert_synchronous_unit_set(synchronous_unit_set& a)
{
	copy(a.unit_table_.begin(), a.unit_table_.end(),
		back_inserter(unit_table_));
}

void synchronous_unit_set::erase_synchronous_unit_set(synchronous_unit_set& a)
{
	container_type::iterator p;
	for (p = a.unit_table_.begin(); p != a.unit_table_.end(); p++) {
		remove(unit_table_.begin(), unit_table_.end(), *p);
	}
}

void synchronous_unit_set::clock_in(void)
{
	for (size_t i = 0; i < unit_table_.size(); i++) unit_table_[i]->clock_in();
}

void synchronous_unit_set::clock_out(void)
{
	for (size_t i = 0; i < unit_table_.size(); i++) unit_table_[i]->clock_out();
}

void synchronous_unit_set::reset(void)
{
	for (size_t i = 0; i < unit_table_.size(); i++) unit_table_[i]->reset();
}
