/* -*- C++ -*-
 *
 * <<< multiprocessor.h >>>
 *
 * --- Abstract multiprocessor class 'multiprocessor'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef MULTIPROCESSOR_H
#define MULTIPROCESSOR_H 1

#include <cstddef>
#include <isis/synchronous_unit_set.h>

template <class T>
class multiprocessor : public synchronous_unit_set
{
private:
	typedef multiprocessor<T> thisclass;
	typedef synchronous_unit_set inherited;
public:
	typedef typename T::address_type address_type;
	typedef typename T::data_type data_type;
	typedef typename T::char_type char_type;
	typedef typename T::size_type size_type;
	typedef typename T::processor_type processor_type;
	typedef typename T::memory_map_type memory_map_type;
	typedef T processing_element_type;
	virtual const processing_element_type& processing_element(size_t)
		const = 0;
	virtual processing_element_type& processing_element(size_t) = 0;
	virtual size_t processor_number(void) const = 0;
	virtual void set_processor_number(size_t) = 0;
	virtual bool is_halt(void) const;
	virtual bool is_bus_error(void) const;
};

template <class T>
bool multiprocessor<T>::is_halt(void) const
{
	for (size_t i = 0; i < processor_number(); i++) {
		if (processing_element(i).is_halt()) return true;
	}
	return false;
}

template <class T>
bool multiprocessor<T>::is_bus_error(void) const
{
	for (size_t i = 0; i < processor_number(); i++) {
		if (processing_element(i).is_bus_error()) return true;
	}
	return false;
}

#endif /* MULTIPROCESSOR_H */
