/*
 * <<< dummy_network_interface.h >>>
 *
 * --- Dummy network interface class 'dummy_network_interface'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef DUMMY_NETWORK_INTERFACE_H
#define DUMMY_NETWORK_INTERFACE_H

#include <isis/network_interface.h>

template <class P>
class dummy_network_interface : public network_interface<P>
{
private:
	typedef dummy_network_interface<P> thisclass;
	typedef network_interface<P> inherited;
public:
	typedef inherited::packet_type packet_type;
	typedef inherited::node_address_type node_address_type;
	typedef inherited::timestamp_type timestamp_type;
protected:
	virtual packet_type* generate_send_packet
		(node_address_type, node_address_type, size_t);
public:
	dummy_network_interface(void) : inherited() {}
	dummy_network_interface(const thisclass& a) : inherited(a) {}
	virtual ~dummy_network_interface() {}
	virtual void clock_out(void);
	bool is_ready(void) const { return is_ready_to_enqueue(); }
	void send_packet(node_address_type dst, size_t len)
		{ enqueue_send_packet(generate_send_packet(node_address(), dst, len)); }
};

template <class P>
dummy_network_interface<P>::packet_type*
	dummy_network_interface<P>::generate_send_packet
	(dummy_network_interface<P>::node_address_type src,
	 dummy_network_interface<P>::node_address_type dst,
	 size_t len)
{
	packet_type* p = new packet_type;
	p->set_source(src);
	p->set_destination(dst);
	p->set_length(len);
	return p;
}

template <class P>
void dummy_network_interface<P>::clock_out(void)
{
	inherited::clock_out();
	if (is_ready_to_dequeue()) {
		packet_type* pkt = dequeue_received_packet();
		delete pkt;
	}
}

#endif /* DUMMY_NETWORK_INTERFACE_H */
