/*
 * <<< root_object_test.cc >>>
 *
 * --- Test for root_object class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "root_object.h"

class root_object_test : public root_object
{
	private:
		int buf;
	public:
		root_object_test(void) : buf(0) {}
		virtual bool check_invariant(void) const { return 1; }
		virtual root_object* new_object(void) const;
		virtual root_object* clone_object(void) const;
		virtual void input(istream&);
		virtual void output(ostream&) const;
};

root_object* root_object_test::new_object(void) const
{
	return new root_object_test;
}

root_object* root_object_test::clone_object(void) const
{
	return new root_object_test(*this);
}

void root_object_test::input(istream& is)
{
	is >> buf;
}

void root_object_test::output(ostream& os) const
{
	os << buf;
#	ifdef DEBUG
		os.flush();
#	endif // DEBUG
}

int main(void)
{
	root_object_test a;
	cin >> a;
	cout << a << endl;
	return 0;
}
