/* -*- C++ -*-
 *
 * <<< r3010_typedef.h >>>
 *
 * --- Definitions of types for R3010 'r3010_typedef'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_TYPEDEF_H
#define R3010_TYPEDEF_H 1

#include <cfloat>
#include <isis_config.h>

/* definition of s_float type for R3010 (single precision) */
#if (SIZEOF_FLOAT >= 4)
	typedef float r3010_sfloat;
#elif (SIZEOF_DOUBLE >= 4)
	typedef double r3010_sfloat;
#else /* (SIZEOF_DOUBLE < 4) */
#	error "Sizeof(double) is too small. Can't compile."
#endif

/* definition of d_float type for R3010 (double precision) */
#if (SIZEOF_FLOAT >= 8)
	typedef float r3010_dfloat;
#elif (SIZEOF_DOUBLE >= 8)
	typedef double r3010_dfloat;
#else /* (SIZEOF_DOUBLE < 8) */
#	error "Sizeof(double) is too small. Can't compile."
#endif

#endif /* R3010_TYPEDEF_H */
