/*
 * <<< r3010_stage.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip>
#include <iostream>
#include "r3010_fgr.h"
#include "r3010_fgrbuf.h"
#include "r3010_fcr.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_forward.h"
#include "r3010_forwarder.h"
#include "r3010.h"

r3010_stage::r3010_stage( r3010_base *parent ) : fpa(parent), csr(parent)
{
}

void
r3010_stage::reset()
{
	for( int i = 0; i < 3; i++ ) {
		valid[i] = false;
		reg[i].reset();
	}
	_fpcond.valid = false;

	inst.reset();
	need_release = false;
	forward_id[0] = forward_id[1] = 0;
	stage = if_stage;

	need_stall = false;
	need_wait = false;

	rd_state = rd_none;
	alu_state = alu_none;
	mem_state = mem_none;
	fwb_state = fwb_none;
}

/* ----------------- IF STAGE --------------- */
void
r3010_stage::if_clock()
{
	if( fpa->s_rd == 0 ) { // next stage is empty
		fpa->s_rd = this;
		fpa->s_if = 0;

		stage = rd_stage;
	}
}

/* ----------------- RD STAGE --------------- */
// r3010_rd.cc

/* ----------------- ALU STAGE -------------- */
// r3010_alu.cc

/* ----------------- MEM STAGE -------------- */
// r3010_mem.cc

/* ----------------- WB STAGE --------------- */
void
r3010_stage::wb_clock()
{
	if( fpa->s_fwb == 0 ) {
		fpa->s_fwb = this;
		fpa->s_wb = 0;

		stage = fwb_stage;
	}
}

/* ----------------- FWB STAGE -------------- */
void
r3010_stage::fwb_clock()
{
	if (valid[r3010_inst::REG_DST]) {
		if (inst.is_calc()) {
			fpa->fgr().reg(idx[r3010_inst::REG_DST]) = reg[r3010_inst::REG_DST];
		} else if (idx[r3010_inst::REG_DST] >= NFGR) {
			fpa->fcr().write_word(
				idx[r3010_inst::REG_DST] - NFGR,
				reg[r3010_inst::REG_DST].read_word(
					idx[r3010_inst::REG_DST] % 2));
		} else {
			fpa->fgr().write_word(
				idx[r3010_inst::REG_DST],
				reg[r3010_inst::REG_DST].read_word(
					idx[r3010_inst::REG_DST] % 2));
		}
	}

	if (need_release) {
#if 0
		if (inst.is_calc()) {
			fpa->release_reg(idx[r3010_inst::REG_DST] ^ 1);
		}
		fpa->release_reg(idx[r3010_inst::REG_DST]);
#endif
	}

	if (forward_id[0]) fpa->forward->del(forward_id[0]);
	if (forward_id[1]) fpa->forward->del(forward_id[1]);

	fwb_state = fwb_next;
	stage = go_out;
}

ostream& operator<<( ostream& os, const r3010_stage& st )
{
	const long flags = os.flags();
	const char fill = os.fill();
	int i;
	char *st_name[] = { "IF", "RD", "ALU", "MEM", "WB", "FWB", "none" };
	os << "{" << st_name[st.stage] << ":";
	if (st.inst.have_inst()) {
		os << "0x" << hex << setw(8) << setfill('0') << st.inst.inst() << ' '
		   << dec << st.inst;
	} else {
		os << st.inst;
	}
	os << ":" << "reg[] = { ";
	for (i = 0; i < 3; i++) {
		os << '{';
		if (st.valid[i]) {
			os << st.idx[i] << ", " << st.reg[i];
		} else {
			os << "*INV*";
		}
		os << '}';
		if (i < 2) os << ", ";
	}
	os << " }}";
	os.flags(flags);
	os.fill(fill);
	return os;
}
