/* -*- C++ -*-
 *
 * <<< r3010_freelist.h >>>
 *
 * --- Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FREELIST_H
#define R3010_FREELIST_H 1

template <class T>
class r3010_freelist
{
private:
	class freelist_item {
		freelist_item* next_;
		T item;
	public:
		freelist_item(void) : next_(0), item(0) {}
		T get(void) { return item; }
		void put(T d) { item = d; }
		freelist_item* next(void) const { return next_; }
		void chain(freelist_item* d) { next_ = d; }
	};
	freelist_item* head;
	freelist_item* free;
public:
	r3010_freelist(void) : head(0), free(0) {}
	T get(void);
	void put(T);
};

template<class T>
T r3010_freelist<T>::get(void)
{
	freelist_item *i = head;
	if (i) {
		head = head->next();
		i->chain(free);
		free = i;
		return i->get();
	}
	return T(0);
}

template<class T>
void r3010_freelist<T>::put(T d)
{
	freelist_item *i = free;
	if (i) {
		free = free->next();
	} else {
		i = new freelist_item;
	}
	i->put(d);
	i->chain(head);
	head = i;
}

#endif /* R3010_FREELIST_H */
