/* -*- C++ -*-
 *
 * <<< r3010_fgrbuf.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FGRBUF_H
#define R3010_FGRBUF_H 1

#include <isis/r3000_typedef.h>
#include "r3010_typedef.h"
#include "r3010_fgr.h"

class r3010_fgrbuf
{
private:
	static const int NFGR = 32;
	r3010_fgr *regs;
public:
	r3010_fgrbuf(void) { regs = new r3010_fgr[NFGR / 2]; }
	void reset(void) { for (int i = 0; i < NFGR / 2; i++) regs[i].reset(); }
	r3000_word read_word(int regnum)
		{ return regs[regnum / 2].read_word(regnum % 2); }
	r3010_sfloat read_single(int regnum)
		{ return regs[regnum / 2].read_single(regnum % 2); }
	r3010_dfloat read_double(int regnum)
		{ return regs[regnum / 2].read_double(); }
	void write_word(int regnum, r3000_word data)
		{ regs[regnum / 2].write_word(regnum % 2, data); }
	void write_single(int regnum, r3010_sfloat data)
		{ regs[regnum / 2].write_single(regnum % 2, data); }
	void write_double(int regnum, r3010_dfloat data)
		{ regs[regnum / 2].write_double(data); }
	r3010_fgr& reg(int i) { return regs[i / 2]; }
};

#endif /* R3010_FGRBUF_H */
