/* -*- C++ -*-
 *
 * <<< r3010_add.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_ADD_H
#define R3010_ADD_H 1

#include "r3010_fgr.h"
#include "r3010_forward.h"

class r3010_base;
class ostream;

class r3010_add {
private:
	struct add_wait : public r3010_forward {
		void *forward_id[2];
		void clear() {
			forward_id[0] = forward_id[1] = 0;
			regnum = -1;
		}
		add_wait(void);
	};
	r3010_base *const fpa;
	int _dst;
	r3010_fgr _val;
	int timer;
	int ofs;	// queueing offset
	enum add_state_t { add_idle, add_calc, add_writeback, add_external } state;
	add_wait wait_queue[3];
	int queue_pointer;
	void* forward_id[2];
	bool stall_mode;
	void enq(int rn, r3010_fgr* v, void* id1 = 0, void* id2 = 0, int idx = 0);
	add_wait *deq() {
		const int wait_queue_len = sizeof(wait_queue) / sizeof(wait_queue[0]);
		return &wait_queue[
			(queue_pointer + wait_queue_len - 1) % wait_queue_len
		];
	}
	void queue_step() {
		const int wait_queue_len = sizeof(wait_queue) / sizeof(wait_queue[0]);
		queue_pointer = (queue_pointer + wait_queue_len - 1) % wait_queue_len;
	}
	void writeback( r3010_forward* );
public:
	r3010_add(r3010_base *p) : fpa(p) { queue_pointer = 0; }
	void reset();
	void clock();
	bool in_use() const { return state != add_idle; }
	void start(int dst, r3010_fgr& val, int time = 2, bool stall = false);
	void external(int timer, r3010_fgr& val, int dst = -1, bool stall = false);
	void forward();
	bool is_stall_mode() const { return stall_mode; }
	friend ostream& operator<<(ostream&, const r3010_add&);
};

#endif /* R3010_ADD_H */
