/* -*- C++ -*-
 *
 * <<< r3000_stall.h >>>
 *
 * --- R3000 stall class 'r3000_stall'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_STALL_H
#define R3000_STALL_H 1

class r3000_stall
{
public:
	enum stall_type {
		MICRO_TLB_MISS_STALL,
		MULTI_PROCESSOR_STALL,
		PARTIAL_WORD_STORES_FIXUP,
		COPROCESSOR_IFETCH_BUSY_STALL,
		COPROCESSOR_IFETCH_BUSY_FIXUP,
		COPROCESSOR_FETCH_BUSY_STALL,
		COPROCESSOR_FETCH_BUSY_FIXUP,
		COPROCESSOR_OUTPUT_BUSY_STALL,
		COPROCESSOR_OUTPUT_BUSY_FIXUP,
		INSTRUCTION_CACHE_MISS_STALL,
		INSTRUCTION_CACHE_MISS_REFILL,
		INSTRUCTION_CACHE_MISS_FIXUP,
		INSTRUCTION_CACHE_MISS_FIXUP_TO_STREAMING,
		UNCACHEABLE_INSTRUCTION_STALL,
		UNCACHEABLE_INSTRUCTION_FIXUP,
		WRITE_BUSY_STALL,
		WRITE_BUSY_FIXUP,
		DATA_CACHE_MISS_STALL_WFLUSH,
		DATA_CACHE_MISS_STALL,
		DATA_CACHE_MISS_REFILL,
		DATA_CACHE_MISS_FIXUP,
		UNCACHEABLE_DATA_STALL_WFLUSH,
		UNCACHEABLE_DATA_STALL,
		UNCACHEABLE_DATA_FIXUP,
		MULTIPLY_UNIT_BUSY_STALL,
		MULTIPLY_UNIT_BUSY_FIXUP
	};
private:
	typedef r3000_stall thisclass;
	stall_type type_;
public:
	inline static int stall_type_to_int(stall_type a) { return int(a); }
	inline static stall_type int_to_stall_type(int a) { return stall_type(a); }
	r3000_stall(void) {}
	r3000_stall(stall_type a) : type_(a) {}
	r3000_stall(const r3000_stall& a) : type_(a.type_) {}
	inline stall_type type(void) const { return type_; }
	inline void set(stall_type a) { type_ = a; }
	inline bool internal_cause_stall(void) const;
	inline bool external_cause_stall(void) const;
};

inline bool r3000_stall::internal_cause_stall(void) const
{
	switch (type_) {
	case COPROCESSOR_IFETCH_BUSY_STALL:
	case COPROCESSOR_IFETCH_BUSY_FIXUP:
	case COPROCESSOR_FETCH_BUSY_STALL:
	case COPROCESSOR_FETCH_BUSY_FIXUP:
	case COPROCESSOR_OUTPUT_BUSY_STALL:
	case COPROCESSOR_OUTPUT_BUSY_FIXUP:
	case MULTIPLY_UNIT_BUSY_STALL:
	case MULTIPLY_UNIT_BUSY_FIXUP:
		return true;
	default:
		return false;
	}
}

inline bool r3000_stall::external_cause_stall(void) const
{
	return !internal_cause_stall();
}

#endif /* R3000_STALL_H */
