/*
 * <<< r3000_register_file.cc >>>
 *
 * --- R3000 register file class 'r3000_register_file'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cctype>
#include <cstring> // needed only for SGI C++ compiler
#include <iomanip>
#include <iostream>
#include "r3000_register_file.h"

string r3000_register_file::register_name(int i)
{
	string value;
	switch (i) {
	case 0:
		value = "zero";
		break;
	case 1:
		value = "at";
		break;
	case 2: case 3:
		value = 'v';
		value += char('0' + (i - 2));
		break;
	case 4: case 5: case 6: case 7:
		value = 'a';
		value += char('0' + (i - 4));
		break;
	case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15:
		value = 't';
		value += char('0' + (i - 8));
		break;
	case 16: case 17: case 18: case 19: case 20: case 21: case 22: case 23:
		value = 's';
		value += char('0' + (i - 16));
		break;
	case 24: case 25:
		value = 't';
		value += char('0' + (i - 16));
		break;
	case 26: case 27:
		value = 'k';
		value += char('0' + (i - 26));
		break;
	case 28:
		value = "gp";
		break;
	case 29:
		value = "sp";
		break;
	case 30:
		value = "fp";
		break;
	case 31:
		value = "ra";
		break;
	}
	return value;
}

int r3000_register_file::register_number(const string& a)
{
	int i;
	if (a[0] == 'r' || a[0] == 'R') {
		if (a.length() == 2 && isdigit(a[1])) {
			return int(a[1] - '0');
		} else if (a.length() == 3 && isdigit(a[1]) && isdigit(a[2])) {
			int num = int(a[1] - '0') * 10 + int(a[2] - '0');
			if (num >= 0 || num < 32) return num;
		}
	}
	for (i = 0; i < 32; i++) {
		if (register_name(i) == a) return i;
	}
	return -1; /* error */
}

r3000_register_file::r3000_register_file(void)
{}

r3000_register_file::r3000_register_file(const r3000_register_file& a)
	: inherited(a)
{}

r3000_register_file::~r3000_register_file()
{}

void r3000_register_file::output(ostream& os) const
{
	char char_table[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
	const char fill = os.fill();
	const long flags = os.flags();
	os << hex << setfill('0');
	for (size_t i = 1; i < size(); i++) {
		os << 'r' << char_table[i / 10] << char_table[i % 10]
		   << '(' << register_name(i)
		   << "):" << setw(8) << (*this)[i];
		if ((i & 3) == 0) os << '\n';
		else			  os << ' ';
	}
	os.fill(fill);
	os.flags(flags);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}
