/*
 * <<< network_packet.h >>>
 *
 * --- Network packet class 'network_packet'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef NETWORK_PACKET_H
#define NETWORK_PACKET_H

#include <isis/network_packet_base.h>

template <class A, class D = unsigned int>
class network_packet : public network_packet_base<A>
{
private:
	typedef network_packet<A, D> thisclass;
	typedef network_packet_base<A> inherited;
public:
	typedef typename inherited::address_type address_type;
	typedef typename inherited::size_type size_type;
	typedef inherited::timestamp_type timestamp_type;
	typedef D data_type;
private:
	typedef vector<data_type> data_container_type;
	data_container_type data_tbl_;
public:
	network_packet(void) {}
	network_packet(const thisclass& a) : inherited(a), data_tbl_(a.data_tbl_) {}
	virtual ~network_packet() {}
	virtual root_object* new_object(void) const
		{ return new thisclass; }
	virtual root_object* clone_object(void) const
		{ return new thisclass(*this); }
	// functions for data management
	size_type data_size(void) const { return data_tbl_.size(); }
	void set_data_size(size_type a) { data_tbl_.resize(a); }
	data_type data(size_type i) const { return data_tbl_[i]; }
	void set_data(size_type i, data_type a) { data_tbl_[i] = a; }
};

#endif /* NETWORK_PACKET_H */
