/*
 * <<< set_associative_cache_test.cc >>>
 *
 * --- Test program for set_associative_cache class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include "simple_cache_line.h"
#include "set_associative_cache.h"

typedef unsigned word;
typedef simple_cache_line<word, word> cache_line_t;
typedef cache_line_set<cache_line_t> cache_line_set_t;
typedef set_associative_cache<cache_line_t> cache_t;

inline word word_random(void)
{
	static unsigned long seed;
	return seed = 1566083941UL * seed + 1;
}

int main(int argc, char** argv)
{
	const int cache_size = 0x100, line_size = 0x10, way_size = 4;
	cache_t cc(cache_size, line_size, way_size);
	const int count = ((argc > 1) ? atoi(argv[1]) : 10);
	for (int i = 0; i < count; i++) {
		word adr = cc.tag_address(word_random() >> 23);
		cerr << "adr:0x" << hex << adr << dec << ' ';
		cache_line_set_t& cls = cc.cache_line_set(adr);
		cache_line_t* cl;
		int way_index = cls.way_of_hit(adr);
		if (way_index >= 0) {
			// hit
			cls.increment_lru_counter(way_index);
			cerr << "hit";
		} else if (cls.is_full()) {
			// full
			way_index = cls.way_of_throw();
			cls.clear_lru_counter(way_index);
			cerr << "replace";
		} else {
			// not full but miss
			way_index = cls.way_of_empty();
			cerr << "miss";
		}
		cerr << " - " << way_index << endl;
		cl = &cls[way_index];
		cl->set_valid();
		cl->tag() = adr;
		for (size_t j = 0; j < cl->size(); j++) (*cl)[j] = i;
	}
	cout << cc << endl;
	return 0;
}
