/*
 * <<< mapped_memory_test.cc >>>
 *
 * --- Test program for mapped_memory class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif // HAVE_CONFIG_H
#include <iostream>
#include "mapped_memory.h"

#if (SIZEOF_INT >= 4)
 typedef unsigned int word;
#else // !(SIZEOF_INT >= 4)
 typedef unsigned long word;
#endif // !(SIZEOF_INT >= 4)
const size_t sizeof_word = 4;

int main(void)
{
	typedef unsigned int word;
	const word top = 0, size = 0x20;
	mapped_memory<word, word, sizeof_word> mem(top, size * sizeof_word);
	// initial state
	cout << mem << endl;
	// word access test
	mem.write(mem.top(), 1);
	mem.write(mem.top() + sizeof_word, 1);
	unsigned i;
	for (i = 2; i < size; i++) {
		word adr = i * sizeof_word + mem.top();
		word adr_prev1 = adr - sizeof_word;
		word adr_prev2 = adr_prev1 - sizeof_word;
		mem.write(adr, mem.read(adr_prev1) + mem.read(adr_prev2));
	}
	cout << mem << endl;
	// byte access test for big-endian
	mem.set_big_endian();
	for (i = 0; i < mem.size(); i++) {
		mem.write_char(i + mem.top(), char(i));
	}
	for (i = 0; i < mem.size(); i++) {
		if (mem.read_char(i + mem.top()) != char(i)) return 1;
	}
	cout << mem << endl;
	// byte access test for little-endian
	mem.set_little_endian();
	for (i = 0; i < mem.size(); i++) {
		mem.write_char(i + mem.top(), char(i));
	}
	for (i = 0; i < mem.size(); i++) {
		if (mem.read_char(i + mem.top()) != char(i)) return 1;
	}
	cout << mem << endl;
	// resize test
	mem.set_top(mem.top() + 0x100);
	cout << mem << endl;
	mem.resize(mem.size() + 0x10);
	cout << mem << endl;
	// dump test
	mem.dump(cout);
	cout << endl;
	mem.dump(cout, mem.top() + 0x18, mem.size() - 0x30);
	cout << endl;
	return 0;
}
