/*
 * <<< fileio_map_test.cc >>>
 *
 * --- Test program for fileio_map class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <queue>
#include <isis/io_protocol.h>
#include "fileio_map.h"

int main(int argc, char** argv)
{
	char buf[4096];
	fileio_map fmap(5);
	fmap.set_standard_io();
	if (!fmap.is_readable(0) || !fmap.is_writable(1) || !fmap.is_writable(2)) {
		return 1;
	}
	{
		char* p = buf;
		char c;
		while (fmap.get(0, c)) {
			*p = c;
			p++;
		}
		*p = '\0';
	}
	{
		char* p = buf;
		while (*p != '\0') {
			fmap.put(1, *p);
			p++;
		}
	}
	{
		char* p = buf;
		while (*p != '\0') {
			fmap.put(2, *p);
			p++;
		}
	}
	if (argc != 3) return 0;
	fmap.open(3, argv[1], IO_FILE_OPEN_RDONLY);
	fmap.open(4, argv[2],
			  IO_FILE_OPEN_WRONLY | IO_FILE_OPEN_CREAT | IO_FILE_OPEN_TRUNC);
	if (!fmap.is_readable(3) || !fmap.is_writable(4)) {
		return 1;
	}
	{
		char c;
		while (fmap.get(3, c)) fmap.put(4, c);
	}
	return 0;
}
