/*
 * <<< cui_debugger_test.cc >>>
 *
 * --- Test program for cui_debugger
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <isis/r3000_processing_element.h>
#include "cui_debugger.h"
#include <isis/isis.h>

int main(int, char** argv)
{
	typedef r3000_processing_element processing_element_type;
	typedef processing_element_type::address_type address_type;
	if (argv[1] == NULL) {
		cerr << "No executable file specified." << endl;
		return 1;
	}
	cui_debugger<processing_element_type> mon;
	processing_element_type pe;
	pe.set_local_memory_area(0, 0x10000000);
	if (!pe.load(argv[1])) {
		cerr << argv[1] << ": No such file or directory." << endl;
		return 1;
	}
	pe.set_instruction_cache_size(0x2000, 0x10);
	pe.set_data_cache_size(0x2000, 0x10);
	pe.set_file_table_size(16);
	pe.set_standard_input_stream(cin);
	pe.set_standard_output_stream(cout);
	pe.set_standard_error_stream(cerr);
	pe.set_commandline_argument((const char* const*)(argv + 1));
	mon.set(pe);
	mon.set_prompt("> ");
	mon.interactive_mode();
	return 0;
}
