/*
 * <<< random_access_processor_test.cc >>>
 *
 * --- Test program for random_access_processor class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <isis/bus_port.h>
#include <isis/mapped_memory.h>
#include "random_access_processor.h"
#include "memory_control_unit.h"

int main(int argc, char **argv)
{
	typedef unsigned int word;
	const word top = 0, size = 0x100;
	random_access_processor<word> pu;
	const int count = (argc > 1) ? atoi(argv[1]) : 20;
	mapped_memory<word, word> mem_buf(top, size);
	memory_control_unit<word> mem;
	bus_port<word> mon;
	pu.port_ref().connect(mem.port_ref());
	pu.port_ref().connect(mon);
	pu.set_access_probability(.2);
	pu.set_read_probability(.8);
	pu.set_address(top, size);
	mem.connect_memory(mem_buf);
	mem.set_read_wait(4);
	mem.set_write_wait(4);
	int run_count, stall_count, read_count, write_count;
	stall_count = read_count = write_count = 0;
	for (int i = 0; i < count; i++) {
		if (pu.is_stall()) stall_count++;
		if (pu.is_reading()) read_count++;
		if (pu.is_writing()) write_count++;
		cerr << " in: " << mon << ", " << pu << endl;
		pu.clock_in();
		mem.clock_in();
		cerr << "out: " << mon << ", " << pu << endl;
		pu.clock_out();
		mem.clock_out();
	}
	cout << mem_buf << endl << endl;
	run_count = count - stall_count;
	cout << "calc:  " << setw(8) << run_count
		 << " (" << setw(7) << 100. * run_count / count << "%)" << endl;
	cout << "stall: " << setw(8) << stall_count
		 << " (" << setw(7) << 100. * stall_count / count << "%)" << endl;
	cout << "read:  " << setw(8) << read_count
		 << " (" << setw(7) << 100. * read_count / count << "%)" << endl;
	cout << "write: " << setw(8) << write_count
		 << " (" << setw(7) << 100. * write_count / count << "%)" << endl;
	return 0;
}
