/* -*- C++ -*-
 *
 * <<< r3010_stage.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_STAGE_H
#define R3010_STAGE_H 1

#include "r3010_inst.h"
#include "r3010_fgr.h"
#include "r3010_fcr.h"

class ostream;
class r3010_base;

class r3010_stage
{
private:
	static const int NFGR = 32;
	static const int R3010_CSR = 31;
private:
	r3010_base* const fpa;
	r3010_fgr reg[3]; // reg[n] will contain a word for FCR.
	bool valid[3];
	int idx[3];
	r3010_csr csr;
	struct {
		bool valid; // Did this instruction set flag?
		bool flag;
	} _fpcond;
	r3010_inst inst;
	bool need_release;
	void* forward_id[2];
	enum {
		if_stage, rd_stage, alu_stage, mem_stage, wb_stage, fwb_stage,
		go_out
	} stage;
	// -------- IF stage ---------
	// -------- RD stage ---------
	enum rd_state_t {
		rd_none, rd_wait, rd_read_data, rd_lock_reg, rd_wait_stall
	} rd_state;
	bool need_stall;	// successor waits I finished if true
	bool need_wait;		// I wait predecessors finished if true
	bool get_data(int, r3010_fgr&);
	bool is_locked(int);
	bool tas(int);
	void rd_go_next(void);
	void rd_get_csr(void);
	bool rd_have_calc_predecessor(void);
	bool rd_have_stall_mode_predecessor(void);
	// -------- ALU stage --------
	enum alu_state_t {
		alu_none, alu_delay, alu_next, alu_wait_bus
	} alu_state;
	int alu_timer;
	void alu_go_next(void);
	void calc_s(void);
	void calc_d(void);
	void calc_w(void);
	// -------- MEM stage --------
	enum mem_state_t {
		mem_none, mem_in, mem_out, mem_next
	} mem_state;
	bool pre_mem_exec(void);
	// --------- WB stage --------
	// -------- FWB stage --------
	enum fwb_state_t {
		fwb_none, fwb_next
	} fwb_state;
public:
	r3010_stage(r3010_base*);
	void reset(void);
	void if_clock(void);
	void rd_clock(void);
	bool have_inst(void) const;
	void instruction_fetch(r3000_word);
	void alu_clock(void);
	void mem_clock(void);
	void wb_clock(void);
	void fwb_clock(void);
	bool fwb_go_next(void) const { return fwb_state == fwb_next; }
	friend ostream& operator<<(ostream&, const r3010_stage&);
};

ostream& operator<<(ostream&, const r3010_stage&);

#endif /* R3010_STAGE_H */
