/* -*- C++ -*-
 *
 * <<< r3010_fcr.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FCR_H
#define R3010_FCR_H 1

#include <isis/r3000_typedef.h>
#include "r3010_float_wrapper.h"

class r3010_base;

class r3010_fcr
{
protected:
	const r3010_base* fpa;
	r3000_word d;
public:
	r3010_fcr(const r3010_base* body) : fpa(body), d(r3000_word(0)) {}
	virtual void reset(void) {}
	virtual r3000_word read_word(void) { return d; }
	virtual void write_word(r3000_word) {}
};

class r3010_rel : public r3010_fcr
{
public:
	r3010_rel(const r3010_base*);
};

class r3010_csr : public r3010_fcr
{
private:
	static const int R3010_CSR_COND_SHIFT = 23;
	static const int R3010_CSR_EXC_SHIFT = 12;
	static const int R3010_CSR_TRAP_SHIFT = 7;
	static const int R3010_CSR_STICKY_SHIFT = 2;
	static const int R3010_CSR_COND_MASK = 0x1;
	static const int R3010_CSR_RM_MASK = 0x3;
	static const int R3010_EXC_I = 0x01;
	static const int R3010_EXC_U = 0x02;
	static const int R3010_EXC_O = 0x04;
	static const int R3010_EXC_Z = 0x08;
	static const int R3010_EXC_V = 0x10;
	static const int R3010_EXC_E = 0x20;
	static const int R3010_EXC_ALL = 0x3f;
	static const int R3010_EXC_MASKABLE = 0x1f;
public:
	r3010_csr(const r3010_base* body) : r3010_fcr(body) {}
	virtual void reset(void);
	virtual void write_word(r3000_word);
	void set_exc(int);
	void set_cond(bool);
	bool exception(void);
	r3000_word get_exc_trap(void) const {
		return (d >> R3010_CSR_TRAP_SHIFT) & R3010_EXC_MASKABLE;
	}
	r3010_float_wrapper::rm_t round_mode(void) const {
		return (r3010_float_wrapper::rm_t)(d & R3010_CSR_RM_MASK);
	}
	bool fpcond(void) const {
		return (d >> R3010_CSR_COND_SHIFT) & R3010_CSR_COND_MASK;
	}
};

class r3010_fcrbuf
{
private:
	static const int NFCR = 32;
	static const int R3010_REL = 0;
	static const int R3010_CSR = 31;
private:
	r3010_fcr **fcr;
	r3010_rel *_rel;
	r3010_csr *_csr;
public:
	r3010_fcrbuf(const r3010_base*);
	void reset(void);
	r3010_rel*& rel(void) { return _rel; }
	r3010_csr*& csr(void) { return _csr; }
	r3000_word read_word(int regnum) {
		return fcr[regnum]->read_word();
	}
	void write_word(int regnum, r3000_word data) {
		fcr[regnum]->write_word(data);
	}
};

#endif /* R3010_FCR_H */
