/*
 * <<< r3010_alu.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * С:
 *	 㳰ϰڤʤƤʤ
 *	 0ʤɤԤ ISIS Τ顼ߤ
 *	 NaN λνϤƤʤ
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <isis/r3000_typedef.h>
#include "r3010_typedef.h"
#include "r3010_float_wrapper.h"
#include "r3010_float_wrapper_local.h"
#include "r3010_forward.h"
#include "r3010_forwarder.h"
#include "r3010_stage.h"
#include "r3010_add.h"
#include "r3010_ext.h"
#include "r3010_base.h"
#include "r3010_debug.h"
#ifdef R3010_DEBUG
# include <iostream>
#endif // R3010_DEBUG

void r3010_stage::alu_clock(void)
{
	switch (alu_state) {
	case alu_none:
		if (!inst.is_fpa() || !inst.is_calc()) {
			alu_state = alu_next;
			goto skip;
		}
		switch (inst.fmt()) {
		case r3010_inst::FMT_S:
			calc_s();
			break;
		case r3010_inst::FMT_D:
			calc_d();
			break;
		case r3010_inst::FMT_W:
			calc_w();
			break;
		default:
			alu_timer = 0;
			break;
		}
		alu_state = alu_delay;
	case alu_delay:
		if (alu_timer > 0) {
			alu_timer--;
			break;
		}
		{
			if (valid[r3010_inst::REG_DST]) {
#ifdef R3010_DEBUG
				if (fpa->debug_level() & R3010_DEBUG_FORWARDING) {
					cerr << "ALU:: forward "
						 << idx[r3010_inst::REG_DST] << "&"
						 << (idx[r3010_inst::REG_DST] ^ 1) << endl;
				}
#endif // R3010_DEBUG
				r3010_forward* f = new r3010_forward;
				f->regnum = idx[r3010_inst::REG_DST];
				f->val = reg[r3010_inst::REG_DST];
				// fpa->forward->put(f, 0);
				forward_id[0] = fpa->forward->put(f);
				f = new r3010_forward;
				f->regnum = idx[r3010_inst::REG_DST] ^ 1;
				f->val = reg[r3010_inst::REG_DST];
				// fpa->forward->put(f, 0);
				forward_id[1] = fpa->forward->put(f);
				fpa->release_reg(idx[r3010_inst::REG_DST]);
				fpa->release_reg(idx[r3010_inst::REG_DST] ^ 1);
			} else {
				// nothing to be done
			}
		}
		alu_state = alu_next;
	case alu_next:
	skip:
		if (fpa->s_mem) break;
		alu_state = alu_wait_bus;
	case alu_wait_bus:
		if (pre_mem_exec()) {
			alu_go_next();
		} else {
#ifdef R3010_DEBUG
			if (fpa->debug_level() & R3010_DEBUG_STALL) {
				cerr << "ALU:bus operation failed, stall" << endl;
			}
#endif // R3010_DEBUG
		}
		break;
	}
}

void r3010_stage::alu_go_next(void)
{
	fpa->s_mem = this;
	fpa->s_alu = 0;
	stage = mem_stage;
}

void r3010_stage::calc_s(void)
{
	alu_timer = 0;
	r3010_sfloat s1, s2 = 0;
	r3010_sfloat result;
	int sign, exp;
	r3000_word frac[2];
	r3010_dfloat result_d;
	r3000_word frac_d[2];
	r3000_word result_w;
	int top, all;
	r3010_float_wrapper::rm_t rm;
	s1 = reg[r3010_inst::REG_SRC1].read_single(idx[r3010_inst::REG_SRC1]);
	if (inst.use_src(r3010_inst::REG_SRC2))
		s2 = reg[r3010_inst::REG_SRC2].read_single(idx[r3010_inst::REG_SRC2]);
	rm = csr.round_mode();
	switch (inst.func()) {
	case r3010_inst::FUNC_ADD:
		result = s1 + s2;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_SUB:
		result = s1 - s2;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_MUL:
		result = s1 * s2;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		fpa->ex_mul().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							r3010_inst::FMT_S, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_DIV:
		result = s1 / s2;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		fpa->ex_div().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							r3010_inst::FMT_S, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_ABS:
		if (s1 < r3010_sfloat(0.)) {
			result = -s1;
		} else {
			result = s1;
		}
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_MOV:
		result = s1;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_NEG:
		result = -s1;
		reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST], result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_CVT_S:
		// ̤̿(EX\_E)ȯʤФʤʤ
		result = s1;
		break;
	case r3010_inst::FUNC_CVT_D:
		if (s1 == r3010_sfloat(0.)) {
			result_d = 0.;
		} else {
			sign = r3010_float_wrapper::get_sign(s1);
			exp = r3010_float_wrapper::get_exp(s1);
			r3010_float_wrapper::get_frac(s1, frac);
			frac_d[0]
				= (frac[0]
				   >> (R3010_SFLOAT_FRAC_LENGTH
					   - (R3010_DFLOAT_FRAC_LENGTH - R3000_WORD_LENGTH)));
			frac_d[1]
				= (frac[0]
				   << (R3010_DFLOAT_FRAC_LENGTH - R3010_SFLOAT_FRAC_LENGTH));
			result_d = r3010_float_wrapper::make_double(sign, exp, frac_d);
		}
		reg[r3010_inst::REG_DST].write_double(result_d);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_CVT_W:
		alu_timer = 2;
		sign = r3010_float_wrapper::get_sign(s1);
		exp = r3010_float_wrapper::get_exp(s1);
		r3010_float_wrapper::get_frac(s1, frac);
		if (exp == EXP_ZERO) {
			result_w = 0;
		} else if (exp == EXP_INFINITY) {
			// ϥХե㳰
			result_w = (sign ? R3000_INT_MIN_VALUE : R3000_INT_MAX_VALUE);
		} else if (exp >= R3000_INT_VALUE_LENGTH) {
			// ϥХե㳰
			result_w = (sign ? R3000_INT_MIN_VALUE : R3000_INT_MAX_VALUE);
		} else if (exp < -1) {
			result_w = 0;
		} else {
			result_w = (frac[0] >> (R3010_SFLOAT_FRAC_LENGTH - exp));
			if (exp >= 0) result_w |= (1 << exp);
			frac[0] <<= (R3010_SFLOAT_LENGTH - R3010_SFLOAT_FRAC_LENGTH + exp);
			top = ((frac[0] & (1LU << (R3010_SFLOAT_LENGTH - 1))) != 0);
			all = (frac[0] != 0);
			switch (rm) {
			case r3010_float_wrapper::ROUND_TO_NEAREST:
				result_w += top;
				break;
			case r3010_float_wrapper::ROUND_TO_ZERO:
				break;
			case r3010_float_wrapper::ROUND_TO_PLUS_INFINITY:
				if (!sign) result_w += all;
				break;
			case r3010_float_wrapper::ROUND_TO_MINUS_INFINITY:
				if (sign) result_w += all;
				break;
			}
			if (sign && result_w == R3000_INT_MIN_VALUE) {
				// nothing to be done
#if 0
			} else if (result_w > R3000_INT_MAX_VALUE) {
				result_w = R3000_INT_MAX_VALUE;
#endif
			} else if (sign) {
				result_w = ~result_w + 1;
			}
		}
		reg[r3010_inst::REG_DST].write_word(idx[r3010_inst::REG_DST], result_w);
		// fpa->ex_add().external(2, reg[r3010_inst::REG_DST],
		//						  idx[r3010_inst::REG_DST], need_stall);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		alu_timer = 0;
		need_release = false;
		break;
	default:
		if (inst.func() >= r3010_inst::FUNC_C_F) { // compare
			bool less, equal, unordered;
			int cond = inst.func()
					   & (r3010_inst::COND_LESS |
						  r3010_inst::COND_EQUAL |
						  r3010_inst::COND_UNORDERED);
			unordered = false;
			less = (s1 < s2);
			equal = (s1 == s2);
			_fpcond.valid = true;
			_fpcond.flag = ((cond & r3010_inst::COND_LESS) && less)
						 | ((cond & r3010_inst::COND_EQUAL) && equal)
						 | ((cond & r3010_inst::COND_UNORDERED) && unordered);
		} else {
			// ̤̿(EX\_E)ȯʤФʤʤ
		}
		break;
	}
}

void r3010_stage::calc_d(void)
{
	alu_timer = 0;
	r3010_dfloat s1, s2 = 0;
	r3010_dfloat result;
	int top;
	int all;
	r3010_float_wrapper::rm_t rm;
	int sign, exp;
	r3000_word frac[2];
	s1 = reg[r3010_inst::REG_SRC1].read_double();
	if (inst.use_src(r3010_inst::REG_SRC2)) {
		s2 = reg[r3010_inst::REG_SRC2].read_double();
	}
	rm = csr.round_mode();
	switch (inst.func()) {
	case r3010_inst::FUNC_ADD:
		result = s1 + s2;
		reg[r3010_inst::REG_DST].write_double(result);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_SUB:
		result = s1 - s2;
		reg[r3010_inst::REG_DST].write_double(result);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_MUL:
		result = s1 * s2;
		reg[r3010_inst::REG_DST].write_double(result);
		fpa->ex_mul().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							r3010_inst::FMT_D, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_DIV:
		result = s1 / s2;
		reg[r3010_inst::REG_DST].write_double( result );
		fpa->ex_div().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							r3010_inst::FMT_D, need_stall);
		need_release = false;
		break;
	case r3010_inst::FUNC_ABS:
		if (s1 < r3010_dfloat(0.)) {
			result = -s1;
		} else {
			result = s1;
		}
		reg[r3010_inst::REG_DST].write_double(result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_MOV:
		result = s1;
		reg[r3010_inst::REG_DST].write_double(result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_NEG:
		result = -s1;
		reg[r3010_inst::REG_DST].write_double(result);
		valid[r3010_inst::REG_DST] = true;
		break;
	case r3010_inst::FUNC_CVT_S:
		{
			r3010_sfloat result_s;
			alu_timer = 1;
			if (s1 == r3010_dfloat(0.)) {
				result_s = 0.;
			} else {
				sign = r3010_float_wrapper::get_sign(s1);
				exp = r3010_float_wrapper::get_exp(s1);
				r3010_float_wrapper::get_frac(s1, frac);
				r3000_word frac_s;
				frac_s = (frac[0] << (R3010_SFLOAT_FRAC_LENGTH
									  - (R3010_DFLOAT_FRAC_LENGTH
										 - R3010_SFLOAT_LENGTH)))
					   | (frac[1] >> (R3010_DFLOAT_FRAC_LENGTH
									  - R3010_SFLOAT_FRAC_LENGTH));
				// ϴݤ⡼ɤˤäƲ +1, -1 ɬפ
				result_s = r3010_float_wrapper::make_single(sign, exp, frac_s);
			}
			reg[r3010_inst::REG_DST].write_single
				(idx[r3010_inst::REG_DST], result_s);
			fpa->ex_add().start(idx[r3010_inst::REG_DST],
								reg[r3010_inst::REG_DST], alu_timer + 1,
								need_stall);
			alu_timer = 0;
		}
		break;
	case r3010_inst::FUNC_CVT_D:
		// ̤̿(EX\_E)㳰ˤʤ
		result = s1;
		break;
	case r3010_inst::FUNC_CVT_W:
		alu_timer = 2;
		sign = r3010_float_wrapper::get_sign(s1);
		exp = r3010_float_wrapper::get_exp(s1);
		r3010_float_wrapper::get_frac(s1, frac);
		r3000_word result_w;
		if (exp == EXP_ZERO) {
			result_w = 0;
		} else if (exp == EXP_INFINITY) {
			// ϥСե
			result_w = (sign ? R3000_INT_MIN_VALUE : R3000_INT_MAX_VALUE);
		}
		else if (exp >= R3000_INT_VALUE_LENGTH) {
			// ϥСե㳰
			result_w = (sign ? R3000_INT_MIN_VALUE : R3000_INT_MAX_VALUE);
		} else if (exp < -1) {
			result_w = 0;
		} else {
			if (R3010_DFLOAT_FRAC_LENGTH - exp >= R3000_INT_VALUE_LENGTH) {
				result_w
					= (frac[0] >> (R3010_DFLOAT_FRAC_LENGTH
								   - R3000_WORD_LENGTH - exp));
			} else {
				result_w
					= (frac[1] >> (R3010_DFLOAT_FRAC_LENGTH - exp))
					| (frac[0] << (R3010_DFLOAT_LENGTH
								   - (R3010_DFLOAT_FRAC_LENGTH - exp)));
			}
			if (exp >= 0) result_w |= (1 << exp);
			if (exp < int(R3010_DFLOAT_FRAC_LENGTH - R3000_WORD_LENGTH)) {
				frac[0]
					<<= (R3010_DFLOAT_LENGTH - R3010_DFLOAT_FRAC_LENGTH + exp);
				top = ((frac[0] & (1LU << (R3000_WORD_LENGTH - 1))) != 0);
				all = (frac[0] || frac[1]);
			} else {
				frac[1]
					<<= (R3000_WORD_LENGTH - R3010_DFLOAT_FRAC_LENGTH + exp);
				top = ((frac[1] & (1 << (R3000_WORD_LENGTH - 1))) != 0);
				all = (frac[1] != 0);
			}
			switch (rm) {
			case r3010_float_wrapper::ROUND_TO_NEAREST:
				result_w += top;
				break;
			case r3010_float_wrapper::ROUND_TO_ZERO:
				break;
			case r3010_float_wrapper::ROUND_TO_PLUS_INFINITY:
				if (!sign) result_w += all;
				break;
			case r3010_float_wrapper::ROUND_TO_MINUS_INFINITY:
				if (sign) result_w += all;
				break;
			}
			if (sign && result_w == R3000_INT_MIN_VALUE) {
				// nothing to be done
#if 0
			} else if (result_w > R3000_INT_MAX_VALUE) {
				// Сե
#endif
			} else if (result_w && sign) {
				result_w = ~result_w + 1;
			}
		}
		reg[r3010_inst::REG_DST].write_word(idx[r3010_inst::REG_DST], result_w);
		// fpa->ex_add().external(2, reg[r3010_inst::REG_DST],
		//						  idx[r3010_inst::REG_DST], need_stall);
		fpa->ex_add().start(idx[r3010_inst::REG_DST], reg[r3010_inst::REG_DST],
							2, need_stall);
		alu_timer = 0;
		need_release = false;
		break;
	default:
		if (inst.func() >= r3010_inst::FUNC_C_F) { // compare
			bool less, equal, unordered;
			int cond = (inst.func() & 007);
			unordered = false;
			less = (s1 < s2);
			equal = (s1 == s2);
			_fpcond.valid = true;
			_fpcond.flag
				= ((cond & r3010_inst::COND_LESS) && less)
				| ((cond & r3010_inst::COND_EQUAL) && equal)
				| ((cond & r3010_inst::COND_UNORDERED) && unordered);
		} else {
			// ̤̿(EX\_E)ȯʤФʤʤ
		}
		break;
	}
}

void r3010_stage::calc_w(void)
{
	alu_timer = 0;
	r3000_word s1, s2;
	s1 = reg[r3010_inst::REG_SRC1].read_word(idx[r3010_inst::REG_SRC1]);
	if (inst.use_src(r3010_inst::REG_SRC2)) {
		s2 = reg[r3010_inst::REG_SRC2].read_word(idx[r3010_inst::REG_SRC2]);
	}
	switch (inst.func()) {
	case r3010_inst::FUNC_ADD:
	case r3010_inst::FUNC_SUB:
	case r3010_inst::FUNC_MUL:
	case r3010_inst::FUNC_DIV:
	case r3010_inst::FUNC_ABS:
	case r3010_inst::FUNC_MOV:
	case r3010_inst::FUNC_NEG:
		// ̤̿(EX\_E)㳰
		break;
	case r3010_inst::FUNC_CVT_S:
		{
			alu_timer = 2;
			int sign, exp;
			r3000_word frac_s = 0;
			r3010_sfloat result_s;
			if (s1 == 0) {
				sign = 0;
				exp = EXP_ZERO;
			} else {
				sign = (s1 & R3000_INT_SIGN_MASK);
				if (sign) s1 = ~s1 + 1; // negate (but type of s1 is WORD)
				exp = r3010_float_wrapper::get_topbit_index(s1);
				frac_s = (s1 << (R3010_SFLOAT_FRAC_LENGTH - exp))
					   & (~(~0 << R3010_SFLOAT_FRAC_LENGTH));
			}
			result_s = r3010_float_wrapper::make_single(sign, exp, frac_s);
			reg[r3010_inst::REG_DST].write_single(idx[r3010_inst::REG_DST],
												  result_s);
			valid[r3010_inst::REG_DST] = true;
			// fpa->ex_add().external(alu_timer, reg[r3010_inst::REG_DST],
			//						  idx[r3010_inst::REG_DST], need_stall);
			fpa->ex_add().start(idx[r3010_inst::REG_DST],
								reg[r3010_inst::REG_DST], alu_timer + 1,
								need_stall);
			alu_timer = 0;
			need_release = false;
		}
		break;
	case r3010_inst::FUNC_CVT_D:
		{
			alu_timer = 2;
			int sign, exp;
			r3000_word frac_d[2];
			r3010_dfloat result_d;
			if (s1 == 0) {
				sign = 0;
				exp = EXP_ZERO;
			} else {
				sign = (s1 & R3000_INT_SIGN_MASK);
				if (sign) s1 = ~s1 + 1; // negate (but type of s1 is WORD)
				exp = r3010_float_wrapper::get_topbit_index(s1);
				if ((R3010_DFLOAT_FRAC_LENGTH - exp) >= R3000_WORD_LENGTH) {
					frac_d[0] = (s1 << (R3010_DFLOAT_FRAC_LENGTH
										- R3000_WORD_LENGTH - exp))
							  & R3010_DFLOAT_FRAC_MASK_HI;
					frac_d[1] = 0;
				} else {
					frac_d[0] = (s1 >> (R3000_WORD_LENGTH
										- (R3010_DFLOAT_FRAC_LENGTH - exp)))
							  & R3010_DFLOAT_FRAC_MASK_HI;
					frac_d[1] = (s1 << (R3010_DFLOAT_FRAC_LENGTH - exp));
				}
			}
			result_d = r3010_float_wrapper::make_double(sign, exp, frac_d);
			reg[r3010_inst::REG_DST].write_double(result_d);
			valid[r3010_inst::REG_DST] = true;
			// fpa->ex_add().external(alu_timer, reg[r3010_inst::REG_DST],
			//						  idx[r3010_inst::REG_DST], need_stall);
			fpa->ex_add().start(idx[r3010_inst::REG_DST],
								reg[r3010_inst::REG_DST], alu_timer + 1,
								need_stall);
			alu_timer = 0;
			need_release = 0;
		}
		break;
	case r3010_inst::FUNC_CVT_W:
		// ̤̿(EX\_E)㳰
		break;
	default:
		// ̤̿(EX\_E)ȯʤФʤʤ
		break;
	}
}
