/* -*- C++ -*-
 *
 * <<< r3010.h >>>
 *
 * --- This file contains the declarations of R3010 class.
 *     Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_H
#define R3010_H 1

#include <string>
#include <isis/r3000_typedef.h>
#include <isis/r3010_base.h>

class ostream;
class r3010_stage;
class r3010_forward;
class r3010_fgrbuf;
class r3010_fcrbuf;
class r3010_csr;
class r3010_bus;
class r3010_add;
class r3010_mul;
class r3010_div;

class r3010 : public r3010_base
{
	static int is_dec_string(const string&);
	static int is_hex_string(const string&);
	bool check_arg(const string&, const char*, string&);
	void set_debug_level(const string&);
	bool reg_command(const string&);
public:
	r3010(void) {}
	void reset(void) { r3010_base::reset(); }
	void set_args(int, char const* const*);
	void set_command(const char*);
	// interface functions between R3000 and R3010
	bool instruction_fetch_p(void);
	void instruction_fetch(r3000_word);
	bool data_fetch_p(void);
	void clock(void);
	void data_fetch(r3000_word);
	bool data_out_p(void);
	r3000_word data_out(void);
	void data_out_ok(void);
	bool fpcond(void) const;
	// human interface (?)
	void show_all_fgr(ostream& os) const { r3010_base::show_all_fgr(os); }
	void show_all_fcr(ostream& os) const { r3010_base::show_all_fcr(os); }
	r3000_word get_fgr(int regnum) const;
	r3000_word get_fcr(int regnum) const;
	void set_fgr(int, r3000_word);
	void set_fcr(int, r3000_word);
	friend ostream& operator<<(ostream&, const r3010&);
};

ostream& operator<<(ostream&, const r3010&);

#endif /* R3010_H */
