/*
 * <<< fpa_all_test.cc >>>
 *
 * --- Test program for r3010 classes
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <iomanip>
#include <fstream>

#include "r3010_fcr.h"
#include "r3010_fgr.h"
#include "r3010_forward.h"
#include "r3010_forwarder.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_bus.h"
#include "r3010_add.h"
#include "r3010_ext.h"
#include "r3010.h"

r3000_word text[] = {
#include "tests/text.c"
0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

r3000_word data[] = {
#include "tests/data.c"
};

struct debug {
	r3010 *fpa;

	void main( int, char ** );
};

int
main( int argc, char **argv )
{
	debug deb;

	deb.main( argc, argv );
	return 0;
}

void
debug::main( int argc, char** argv )
{
	unsigned i, j;
	bool inst_f, in_f, out_f;
	r3000_word w;
	r3010_inst inst;
	char command[100];

	fpa = new r3010;
	fpa->reset();
	fpa->set_args( argc, (const char* const*)(argv) );

	cout << "debug level = " << fpa->debug_level() << endl;

	while( 1 ) {
		cout << "cmd:" << flush;
		cin >> command;
		if( command[0] == 'g' )
			break;
		fpa->set_command( command );
	}

//	fpa->_fgr->write_double( 4, 3.1415926536 );

	i = 0; j = 0;
	while( i < sizeof(text)/sizeof(text[0]) ) {
		cout << "#" << i << ":" << endl;

		cout << *fpa << endl;
		cout << "fpcond = " << (fpa->fpcond() ? "TRUE" : "FALSE") << endl;

		in_f = fpa->data_fetch_p();
		if( in_f ) {
			cout << "  FPA requires to input DATA (0x"
				 << hex << setfill( '0' ) << setw( 8 ) << data[j] << dec
				 << ")" << endl;
			fpa->data_fetch( data[j++] );
		}

		out_f = fpa->data_out_p();
		if( out_f ) {
			cout << "  FPA requires to output data : ";
			w = fpa->data_out();
			cout << "0x" << hex << setfill( '0' ) << setw( 8 ) << w
				 << dec << endl;

			fpa->data_out_ok();
		}

		inst_f = fpa->instruction_fetch_p();
		cout << "  " << (inst_f ? "I fetch" : "STALL") << endl;
		if( inst_f ) {
			inst.reset();
			inst.decode( text[i] );
			cout << "  inst: 0x" << hex << setfill( '0' ) << setw( 8 )
				 << text[i] << dec << "  " << inst << endl;
			fpa->instruction_fetch( text[i] );
			i++;
		}

		cout << "  call FPA.clock()" << endl;
		fpa->clock();

		cout << "---------------------------------------" << endl;
	}
}
