/* -*- C++ -*-
 *
 * <<< r3000_base.h >>>
 *
 * --- R3000 base class 'r3000_base' - for custom r3000 processor(s)
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_BASE_H
#define R3000_BASE_H 1

#include <isis/processor.h>
#include <isis/r3000_typedef.h>

class r3000_directmap_cache;
class r3010;

class r3000_base : public processor<r3000_word>
{
private:
	typedef r3000_base thisclass;
	typedef processor<r3000_word> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	static const size_t sizeof_data_type = sizeof_r3000_word;
public:
	virtual bool is_connected_to_instruction_cache(void) const = 0;
	virtual bool is_connected_to_data_cache(void) const = 0;
	virtual bool is_connected_to_coprocessor(void) const = 0;
	virtual void connect_instruction_cache(r3000_directmap_cache&) = 0;
	virtual void connect_data_cache(r3000_directmap_cache&) = 0;
	virtual void connect_coprocessor(r3010&) = 0;
	virtual void disconnect_instruction_cache(void) = 0;
	virtual void disconnect_data_cache(void) = 0;
	virtual void disconnect_coprocessor(void) = 0;
};

#endif /* R3000_BASE_H */
